#include "DemoSkin.h"

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <MeshVizXLM/mapping/nodes/MoMeshSkin.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>

#include <Inventor/STL/algorithm>

using namespace::std;

//---------------------------------------------------------------------
DemoSkin::DemoSkin() :
Demo("MeshVizXLM Skin",VOLUME_MESH_REGULAR,ALL_VOLUME_MESHES_NO_TETRA,true),
m_dimension(MiMesh::DIMENSION_I)
{
}

//---------------------------------------------------------------------
bool DemoSkin::displayInstructions() const
{
  cout << "Press u or d to decrease/increase cell ranges" << endl;
  cout << "Press i to move the range along the i-dimension" << endl;
  cout << "Press j to move the range along the j-dimension" << endl;
  cout << "Press k to move the range along the k-dimension" << endl;
  cout << "Press v to toggle vector visibility" << endl;
  return true;
}

//---------------------------------------------------------------------
void DemoSkin::keyPressed(SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  if ((m_meshType == VOLUME_MESH_UNSTRUCTURED || m_meshType == UNDEFINED_MESH) 
      && m_subskin->maxCellRanges.getNum() !=1)
  {
    m_subskin->maxCellRanges.setNum(1);
    m_subskin->maxCellRanges.setValue( (uint32_t)( m_defaultMeshSize[0]*m_defaultMeshSize[1]*(m_defaultMeshSize[2]-1)-1 ) );
    m_subskin->minCellRanges.setNum(1);
    m_subskin->minCellRanges.setValue( (uint32_t)( m_defaultMeshSize[0]*m_defaultMeshSize[1] ) );
  }
  else if (m_meshType != VOLUME_MESH_UNSTRUCTURED && m_subskin->maxCellRanges.getNum() != 3)
  {
    MbVec3<uint32_t> mcellRange(m_defaultMeshSize-2);
    m_subskin->maxCellRanges.setValues(0,3,&mcellRange[0]);
    m_subskin->minCellRanges.setValues(0,3,&MbVec3<uint32_t>(1)[0]);
  }

  if (SO_KEY_PRESS_EVENT(ev, I) )
    m_dimension = MiMesh::DIMENSION_I;
  else if (SO_KEY_PRESS_EVENT(ev, J) && m_meshType != VOLUME_MESH_UNSTRUCTURED)
    m_dimension = MiMesh::DIMENSION_J;
  else if (SO_KEY_PRESS_EVENT(ev, K) && m_meshType != VOLUME_MESH_UNSTRUCTURED)
    m_dimension = MiMesh::DIMENSION_K;
  if (SO_KEY_PRESS_EVENT(ev, U)) 
  {
    if (m_subskin->minCellRanges[m_dimension] != 0)
    {
      m_subskin->maxCellRanges.set1Value(m_dimension, m_subskin->maxCellRanges[m_dimension] + 1);
      m_subskin->minCellRanges.set1Value(m_dimension, m_subskin->minCellRanges[m_dimension] - 1);
    }
    handled = true;
  } 
  else if (SO_KEY_PRESS_EVENT(ev, D) )
  {
    if (m_subskin->maxCellRanges[m_dimension] >= m_subskin->minCellRanges[m_dimension] + 1)
    {
      m_subskin->maxCellRanges.set1Value(m_dimension, m_subskin->maxCellRanges[m_dimension] - 1);
      m_subskin->minCellRanges.set1Value(m_dimension, m_subskin->minCellRanges[m_dimension] + 1);
    }
    handled = true;
  }
  else if (SO_KEY_PRESS_EVENT(ev, V) )
  {
    m_vectorSwitch->whichChild = ( m_vectorSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
    handled = true;
  }

  if (handled)
    eventCB->setHandled();
}

//---------------------------------------------------------------------
void DemoSkin::getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& /*ids*/, SoPickStyle*& ps)
{
  ps = m_ps = new SoPickStyle;
  ds = m_ds = new MoDrawStyle;
  mat = m_mat = new MoMaterial;
  m_ds->displayFaces = false;
  m_ds->displayEdges = true;
  m_mat->lineColor.setValue(SbColor(0,0,0));
}

//---------------------------------------------------------------------
void DemoSkin::insertRepresentations(SoSeparator* sep)
{
  m_subskin = new MoMeshSkin;
  MbVec3<uint32_t> mcellRange(m_defaultMeshSize-2);
  m_subskin->maxCellRanges.setValues(0,3,&mcellRange[0]);
  m_subskin->minCellRanges.setValues(0,3,&MbVec3<uint32_t>(1)[0]);
  sep->addChild(m_subskin);

  m_vectorSwitch = new SoSwitch;
  MoMesh* subskinMesh = new MoMesh;
  subskinMesh->connectFrom(m_subskin);
  
  sep->addChild(m_vectorSwitch);
  {
    m_vectorSwitch->addChild(subskinMesh);
    MoMeshVector* vector = new MoMeshVector;
    vector->scaleFactor = 0.1f;
    vector->thicknessFactor = 0.5f;
    m_vectorSwitch->addChild(vector);
  }
}


