#include "DemoSlab.h"

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <MeshVizXLM/mapping/nodes/MoMeshSlab.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>

using namespace::std;

//---------------------------------------------------------------------
DemoSlab::DemoSlab() :
Demo("MeshVizXLM Slab",VOLUME_MESH_REGULAR,ALL_IJK_MESHES,true)
{
}

//---------------------------------------------------------------------
bool DemoSlab::displayInstructions() const
{
  cout << "Press u or d to decrease/increase slice index" << endl;
  cout << "Press i to display slice along the i-axis" << endl;
  cout << "Press j to display slice along the j-axis" << endl;
  cout << "Press k to display slice along the k-axis" << endl;
  cout << "Press v to toggle vector visibility" << endl;
  return true;
}

//---------------------------------------------------------------------
void DemoSlab::keyPressed(SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  if (SO_KEY_PRESS_EVENT(ev, U)) 
  {
    m_slab->index.setValue(m_slab->index.getValue()+1);
    handled = true;

  } 
  else if (SO_KEY_PRESS_EVENT(ev, D) )
  {
    int newVal = m_slab->index.getValue()-1;
    if (newVal >= 0) 
      m_slab->index.setValue(newVal);
    handled = true;
  }
  else if (SO_KEY_PRESS_EVENT(ev, I) )
  {
    m_slab->dimension = MiMesh::DIMENSION_I;
    handled = true;
  }
  else if (SO_KEY_PRESS_EVENT(ev, J) )
  {
    m_slab->dimension = MiMesh::DIMENSION_J;
    handled = true;
  }
  else if (SO_KEY_PRESS_EVENT(ev, K) )
  {
    m_slab->dimension = MiMesh::DIMENSION_K;
    handled = true;
  }
  else if (SO_KEY_PRESS_EVENT(ev, V) )
  {
    m_vectorSwitch->whichChild = ( m_vectorSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
    handled = true;
  }

  if (handled)
    eventCB->setHandled();
}

//---------------------------------------------------------------------
void DemoSlab::getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& /*ids*/, SoPickStyle*& ps)
{
  ps = m_ps = new SoPickStyle;
  ds = m_ds = new MoDrawStyle;
  mat = m_mat = new MoMaterial;
  m_ds->displayFaces = false;
  m_ds->displayEdges = true;
  m_mat->lineColor.setValue(SbColor(0,0,0));
}

//---------------------------------------------------------------------
void DemoSlab::insertRepresentations(SoSeparator* sep)
{
  m_slab = new MoMeshSlab;
  sep->addChild(m_slab);

  m_vectorSwitch = new SoSwitch;
  MoMesh* slabMesh = new MoMesh;
  slabMesh->connectFrom(m_slab);
  
  sep->addChild(m_vectorSwitch);
  {
    m_vectorSwitch->addChild(slabMesh);
    MoMeshVector* vector = new MoMeshVector;
    vector->scaleFactor = 0.1f;
    vector->thicknessFactor = 0.5f;
    m_vectorSwitch->addChild(vector);
  }
}


