#include "DemoSphereCylinderPlaneSlices.h"

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <Inventor/manips/SoClipPlaneManip.h>
#include <Inventor/draggers/SoJackDragger.h>
#include <Inventor/nodes/SoPickStyle.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoSwitch.h>

#include <Inventor/sensors/SoNodeSensor.h>

#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoMeshPlaneSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMeshCylinderSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSphereSlice.h>

//---------------------------------------------------------------------
DemoSphereCylinderPlaneSlices::DemoSphereCylinderPlaneSlices() : 
Demo("MeshVizXLM Sphere, Cylinder and Plane Slices",VOLUME_MESH_UNSTRUCTURED,ALL_VOLUME_MESHES,true) 
{
}

//---------------------------------------------------------------------
DemoSphereCylinderPlaneSlices::~DemoSphereCylinderPlaneSlices()
{
}

//---------------------------------------------------------------------
void DemoSphereCylinderPlaneSlices::keyPressed(SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();
  bool handled = true;

  if (m_sliceSwitch) {
    if (SO_KEY_PRESS_EVENT(ev, NUMBER_3))
    {
      m_sliceSwitch->whichChild = 0;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_1))
    {
      m_sliceSwitch->whichChild = 1;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_2))
    {
      m_sliceSwitch->whichChild = 2;
      handled = true;
    }
  }

  if (handled) 
    eventCB->setHandled();
}

//---------------------------------------------------------------------
bool DemoSphereCylinderPlaneSlices::displayInstructions() const
{
  cout << "Press 1 for cylinder slice" << endl;
  cout << "Press 2 for sphere slice" << endl;
  cout << "Press 3 for plane slice" << endl;
  return true;
}

//---------------------------------------------------------------------
void DemoSphereCylinderPlaneSlices::getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& /*ids*/, SoPickStyle*& ps)
{
  ds = new MoDrawStyle;
  mat = new MoMaterial;
  ds->displayFaces = false;
  ds->displayEdges = true;
  mat->lineColoring = MoMaterial::CONTOURING;
  ps = new SoPickStyle;
  ps->style = SoPickStyle::UNPICKABLE;
}

//-------------------------------------------------------------------------------------
// callback called when the field manip->plane has changed
void draggerMotionCB(void *data, SoSensor* sensor)
{
  SoClipPlaneManip* manip = (SoClipPlaneManip*) ((SoNodeSensor*)sensor)->getAttachedNode();
  if (data != NULL)
  {
    if (((SoNode*)data)->isOfType(MoMeshCylinderSlice::getClassTypeId()))
    {
      MoMeshCylinderSlice *cylinderSlice = (MoMeshCylinderSlice *) data;
      cylinderSlice->direction.setValue(manip->plane.getValue().getNormal());
      cylinderSlice->radius.setValue(((SoJackDragger*)manip->getDragger())->scaleFactor.getValue()[0]);
    }
    else if (((SoNode*)data)->isOfType(MoMeshSphereSlice::getClassTypeId()))
    {
      ((MoMeshSphereSlice*)data)->radius.setValue(((SoJackDragger*)manip->getDragger())->scaleFactor.getValue()[0]);
    }
  }
}

//---------------------------------------------------------------------
void DemoSphereCylinderPlaneSlices::insertRepresentations(SoSeparator* sep)
{
  // Manipulator to move the plane slice plane (as a clip plane)
  SoClipPlaneManip *manip = new SoClipPlaneManip;
  manip->plane.setValue(SbPlane(SbVec3f(1,0,1),5.0f));
  // Turn off clip plane visibility to avoid flickering of plane slice faces.
  manip->on.setValue(FALSE); 
  manip->draggerPosition.setValue(this->getCenter());
  sep->addChild(manip);

  m_sliceSwitch = new SoSwitch;
  sep->addChild(m_sliceSwitch);
  m_sliceSwitch->whichChild = 0;

  // Cross Section
  MoMeshPlaneSlice *planeSlice = new MoMeshPlaneSlice;
  m_sliceSwitch->addChild(planeSlice);
  planeSlice->plane.connectFrom(&manip->plane);
  planeSlice->setExtractorCallback(&m_extractorCB);
  // Use data set 0 for coloring
  planeSlice->colorScalarSetId = 0;

    // Cylinder Section
  MoMeshCylinderSlice *cylinderSlice = new MoMeshCylinderSlice;
  m_sliceSwitch->addChild(cylinderSlice);
  cylinderSlice->center.connectFrom(&((SoJackDragger*)manip->getDragger())->translation);
  cylinderSlice->direction.setValue(manip->plane.getValue().getNormal());
  cylinderSlice->radius.setValue(((SoJackDragger*)manip->getDragger())->scaleFactor.getValue()[0]);
  cylinderSlice->setExtractorCallback(&m_extractorCB);
  // Use data set 0 for coloring
  cylinderSlice->colorScalarSetId = 0;
  SoNodeSensor* cylinderSensor = new SoNodeSensor(draggerMotionCB,cylinderSlice);
  cylinderSensor->attach(manip);

  // Sphere Section
  MoMeshSphereSlice *sphereSlice = new MoMeshSphereSlice;
  m_sliceSwitch->addChild(sphereSlice);
  sphereSlice->center.connectFrom(&((SoJackDragger*)manip->getDragger())->translation);
  sphereSlice->radius.setValue(((SoJackDragger*)manip->getDragger())->scaleFactor.getValue()[0]);
  sphereSlice->setExtractorCallback(&m_extractorCB);
  // Use data set 0 for coloring
  sphereSlice->colorScalarSetId = 0;
  SoNodeSensor* sphereSensor = new SoNodeSensor(draggerMotionCB,sphereSlice);
  sphereSensor->attach(manip);

}

