
#include <MbSampleMeshBuilder.h>
#include <MeshVizXLM/mesh/MiLineMeshCurvilinear.h>

#include <colormapping/MbLinearColorMapping.h>
#include <colormapping/MbLevelColorMapping.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetI.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoCustomColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshStreamline.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSkin.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoDataBinding.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoKeyboardEvent.h>

#include "../DemoTemplate/Vec3Set.h"

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM streamline sample program"

MbLinearColorMapping<double,SbColorRGBA,float> linearColorMap;

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4250)
#endif

#define NUM_CELL_I 10
#define NUM_CELL_J 10
#define NUM_CELL_K 10

SoSwitch* m_vectorSwitch;
static MbSampleMeshBuilder<MbVec3d,double> meshBuilder1, meshBuilder2, meshBuilder3;
static MbVolumeMeshRegular<double,double,MbVec3d>* meshIjk = &meshBuilder1.getVolumeMeshRegular(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K), MbVec3d(0), MbVec3d(100));
static MbVolumeMeshHexahedron<MbVec3d,double,MbVec3d>* meshHexa = &meshBuilder2.getMeshHexahedron(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K), MbVec3d(0), MbVec3d(100));
static MbHexahedronMeshIjk<MbVec3d,double,MbVec3d>* meshHexaIjk = &meshBuilder3.getHexahedronMeshIjk(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K), MbVec3d(0), MbVec3d(100));

static Vec3Set speedVec(MbVec3<size_t>((size_t)NUM_CELL_I,(size_t)NUM_CELL_J,(size_t)NUM_CELL_K),MiDataSet::PER_NODE);

void
editStreamlines(void *userData, SoEventCallback *eventCB)
{
  static char axis = ' ';

  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  MoMeshStreamline *streamlines = (MoMeshStreamline*) (userData);
  if (streamlines) {
    if (SO_KEY_PRESS_EVENT(ev, I) )
      axis = 'I';
    else if (SO_KEY_PRESS_EVENT(ev, J) )
      axis = 'J';
    else if (SO_KEY_PRESS_EVENT(ev, K) )
      axis = 'K';
    else if (axis == 'I' && SO_KEY_PRESS_EVENT(ev, U))
    {
        SbVec3f newPoints[5];
        for(int n=0;n<5;++n){
          const SbVec3f* startPoint = streamlines->startingPoints.getValues(n);
          newPoints[n] = *startPoint + SbVec3f(1,0,0);
        }
        streamlines->startingPoints.setValues(0,5,newPoints);
        handled = true;
    }
    else if(axis == 'I' && SO_KEY_PRESS_EVENT(ev, D))
    {
        SbVec3f newPoints[5];
        for(int n=0;n<5;++n){
          const SbVec3f* startPoint = streamlines->startingPoints.getValues(n);
          newPoints[n] = *startPoint - SbVec3f(1,0,0);
        }
        streamlines->startingPoints.setValues(0,5,newPoints);
        handled = true;
    }
    else if (axis == 'J' && SO_KEY_PRESS_EVENT(ev, U) )
    {
      SbVec3f newPoints[5];
      for(int n=0;n<5;++n){
        const SbVec3f* startPoint = streamlines->startingPoints.getValues(n);
        newPoints[n] = *startPoint + SbVec3f(0,1,0);
      }
      streamlines->startingPoints.setValues(0,5,newPoints);
      handled = true;
    }
    else if (axis == 'J' && SO_KEY_PRESS_EVENT(ev, D) )
    {
      SbVec3f newPoints[5];
      for(int n=0;n<5;++n){
        const SbVec3f* startPoint = streamlines->startingPoints.getValues(n);
        newPoints[n] = *startPoint - SbVec3f(0,1,0);
      }
      streamlines->startingPoints.setValues(0,5,newPoints);
      handled = true;
    }
    else if (axis == 'K' && SO_KEY_PRESS_EVENT(ev, U) )
    {
      SbVec3f newPoints[5];
      for(int n=0;n<5;++n){
        const SbVec3f* startPoint = streamlines->startingPoints.getValues(n);
        newPoints[n] = *startPoint + SbVec3f(0,0,1);
      }
      streamlines->startingPoints.setValues(0,5,newPoints);
      handled = true;
    }
    else if (axis == 'K' && SO_KEY_PRESS_EVENT(ev, D) )
    {
      SbVec3f newPoints[5];
      for(int n=0;n<5;++n){
        const SbVec3f* startPoint = streamlines->startingPoints.getValues(n);
        newPoints[n] = *startPoint - SbVec3f(0,0,1);
      }
      streamlines->startingPoints.setValues(0,5,newPoints);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, V) )
    {
      m_vectorSwitch->whichChild = ( m_vectorSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      handled = true;
    }
  }

  if (handled) {
    if(axis == 'I' || axis == 'J' || axis == 'K')
      for(int n=0;n<5;++n)
        std::cout << *streamlines->startingPoints.getValues(n) << " ";
    std::cout<<std::endl;
    eventCB->setHandled();
  }
}

void
editMesh(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  bool handled = false;

  MoMesh *moMesh = (MoMesh*) userData;;
  if (moMesh) {
    if (SO_KEY_PRESS_EVENT(ev, NUMBER_1))
    {
      cout << "Displaying Hexahedon mesh" << endl;
      moMesh->setMesh(meshHexa);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_2))
    {
      cout << "Displaying Regular mesh" << endl;
      moMesh->setMesh(meshIjk);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_3))
    {
      cout << "Displaying Hexahedron meshIjk" << endl;
      moMesh->setMesh(meshHexaIjk);
      handled = true;
    }
  }

  if (handled) 
    eventCB->setHandled();
}

void
editSpeed(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  bool handled = false;

  MoDataBinding *binding = (MoDataBinding*) userData;;
  if (binding) {
    if (SO_KEY_PRESS_EVENT(ev, C))
    {
      cout << "Converting speed into cell values" << endl;
      speedVec.setBinding(MiDataSet::PER_CELL);
      binding->dataBinding = MoDataBinding::PER_CELL;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, N))
    {
      cout << "Converting speed into node values" << endl;
      speedVec.setBinding(MiDataSet::PER_NODE);
      binding->dataBinding = MoDataBinding::PER_NODE;
      handled = true;
    }
  }

  if (handled) 
    eventCB->setHandled();
}

//-----------------------------------------------------------------------------
int
main(int, char **)
{
  cout << "Press 1 for Unstructured mesh" << endl;
  cout << "Press 2 for Regular mesh" << endl;
  cout << "Press 3 for HexahedronIjk mesh" << endl;
  cout << "Press I then press u/d to move starting points along the i-axis" << endl;
  cout << "Press J then press u/d to move starting points along the j-axis" << endl;
  cout << "Press K then press u/d to move starting points along the k-axis" << endl;
  cout << "Press c/n to convert speed vectors into cell or node values" << endl;
  cout << "Press v to toggle vector visibility" << endl;

  Magnitude speed(speedVec);

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;
  
  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(meshIjk);
  sep->addChild(moMesh);

  MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
  colMap->minValue = (float)speed.getMin();
  colMap->maxValue = (float)speed.getMax();
  colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
  sep->addChild(colMap);

  MoDataBinding* dataBinding = new MoDataBinding;
  dataBinding->dataBinding = MoDataBinding::PER_NODE;
  sep->addChild(dataBinding);

  // Vector filed
  MoVec3SetI *moVec3SetI = new MoVec3SetI;
  moVec3SetI->setVec3Set(&speedVec);
  sep->addChild(moVec3SetI);

  // Scalar field
  MoScalarSetI *moScalarSetI = new MoScalarSetI;
  moScalarSetI->setScalarSet(&speed);
  sep->addChild(moScalarSetI);

  // Scalar field
  MoScalarSetIjk *moScalarSetIjk = new MoScalarSetIjk;
  moScalarSetIjk->setScalarSet(&speed);
  sep->addChild(moScalarSetIjk);

  // Vector filed
  MoVec3SetIjk *moVec3SetIjk = new MoVec3SetIjk;
  moVec3SetIjk->setVec3Set(&speedVec);
  sep->addChild(moVec3SetIjk);

  MbVec3d max = meshIjk->getGeometry().getMax();
  MbVec3d min = meshIjk->getGeometry().getMin();
  MbVec3d center = ( max + min )/2.0f;
  SbVec3f sbCenter((float)center[0],(float)center[1],(float)center[2]);

  // Streamline
  MoMeshStreamline* streamline = new MoMeshStreamline;
  streamline->integrationStepLengthFactor = 1;
  streamline->colorScalarSetId = 0;
  streamline->vec3SetId = 0;
  SbVec3d startPoint[5];
  startPoint[0].setValue(sbCenter);
  startPoint[1].setValue((sbCenter + SbVec3f(1,0,0)));
  startPoint[2].setValue((sbCenter + SbVec3f(-1,0,0)));
  startPoint[3].setValue((sbCenter + SbVec3f(0,0,1)));
  startPoint[4].setValue((sbCenter + SbVec3f(0,0,-1)));
  streamline->startingPoints.setValues(0,5,startPoint);
  sep->addChild(streamline);

  // Transparent Mesh Skin
  SoPickStyle* pickStyle = new SoPickStyle;
  pickStyle->style.setValue(SoPickStyle::UNPICKABLE);
  sep->addChild(pickStyle);

  MoDrawStyle * drawstyle = new MoDrawStyle;
  drawstyle->displayEdges = true;
  drawstyle->displayFaces = false;
  sep->addChild(drawstyle);

  MoMeshSkin *skin = new MoMeshSkin;
  skin->colorScalarSetId = 0;
  sep->addChild(skin);

  // This mesh is used to connect the streamlines generated mesh as input of the vectors
  MoMesh* lineMesh = new MoMesh;
  lineMesh->connectFrom(streamline);
  sep->addChild(lineMesh);

  // Display vector on streamline
  m_vectorSwitch = new SoSwitch;
  sep->addChild(m_vectorSwitch);
  MoMeshVector *vector = new MoMeshVector;
  vector->colorScalarSetId = -1;
  vector->scaleFactor = 7;
  vector->thicknessFactor = 0.1f;
  m_vectorSwitch->addChild(vector);

  SoEventCallback *myCallbackNode = new SoEventCallback;
  myCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(), editStreamlines, streamline); 
  sep->addChild(myCallbackNode);

  SoEventCallback *myCallbackNode2 = new SoEventCallback;
  myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editMesh, moMesh); 
  sep->addChild(myCallbackNode2);

  SoEventCallback *myCallbackNode3 = new SoEventCallback;
  myCallbackNode3->addEventCallback(SoKeyboardEvent::getClassTypeId(), editSpeed, dataBinding); 
  sep->addChild(myCallbackNode3);

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;
  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#ifdef _MSC_VER
#pragma warning( pop ) 
#endif

