#include <MbSampleMeshBuilder.h>

#include <MeshVizXLM/mesh/cell/MiCellFilterI.h>
#include <MeshVizXLM/mesh/cell/MiCellFilterIj.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIj.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurface.h>
#include <MeshVizXLM/mapping/nodes/MoCellFilter.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 

#include <Inventor/STL/iostream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM displaying all types of surface meshes with cell filter "

#if defined(_MSC_VER)
#pragma warning( push )
#pragma warning(disable:4250)
#endif

#define NUMCELLI 10
#define NUMCELLJ 5

class MyCellFilterI : public MiCellFilterI
{
public:
  MyCellFilterI() : m_v(0), m_ts(0) {};

  virtual bool acceptCell(size_t i) const 
  { 
    if ((i+m_v)%3) return true;
    else return false;
  }
  virtual size_t getTimeStamp() const 
  { 
    return m_ts; 
  }

  void touch() {
    ++m_v;
    ++m_ts; 
  }

private:
  size_t m_v;
  size_t m_ts;
};

class MyCellFilterIj : public MiCellFilterIj
{
public:
  
  MyCellFilterIj() : m_v(0), m_ts(0) {};

  virtual bool acceptCell(size_t i, size_t j) const 
  { 
    if ((i+m_v)%3 || (j+m_v)%3) return true;
    else return false;
  }
  virtual size_t getTimeStamp() const { return m_ts; }

  void touch() {
    ++m_v;
    ++m_ts; 
  }
 
private:
  size_t m_v;
  size_t m_ts;
};

struct FilterData
{
  MoCellFilter* moCellFilter;
  MiCellFilter* cellFilter;
};

template < typename CellFilterT>
void
editCellFilter(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  FilterData *data = (FilterData*) userData;
  if (data) {
    if (SO_KEY_PRESS_EVENT(ev, F1))
    {
      dynamic_cast<CellFilterT*>(data->cellFilter)->touch();
      data->moCellFilter->touch();
    }
    else if (SO_KEY_PRESS_EVENT(ev, F2))
    {
      if (data->moCellFilter->getCellFilter() == NULL)
        data->moCellFilter->setCellFilter(dynamic_cast<CellFilterT*>(data->cellFilter));
      else
        data->moCellFilter->reset();
    }
  }
}

class UserData
{
public:
  UserData(MoPredefinedColorMapping& c, MbMesh<MbVec3f,float,MbVec3f>* m, MbMeshIj<float,MbVec3f>* mIj, MoScalarSetI* sI, MoScalarSetIj* sIj) :
      mesh(m), meshIj(mIj), colMap(c), moScalarSetI(sI), moScalarSetIj(sIj) {}
  MbMesh<MbVec3f,float,MbVec3f>* mesh;
  MbMeshIj<float,MbVec3f>* meshIj;
  MoPredefinedColorMapping& colMap;
  MoScalarSetI* moScalarSetI;
  MoScalarSetIj* moScalarSetIj;
};

void
editDataSet(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  UserData *data = (UserData*) userData;
  if (data) {
    if (SO_KEY_PRESS_EVENT(ev, F3))
    {
      if(data->mesh)
      {
        data->colMap.minValue = (float)data->mesh->getScalarSet("$MyScalarSet")->getMin();
        data->colMap.maxValue = (float)data->mesh->getScalarSet("$MyScalarSet")->getMax();
        data->moScalarSetI->setScalarSet(data->mesh->getScalarSet("$MyScalarSet")); 
      }
      else if(data->meshIj)
      {
        data->colMap.minValue = (float)data->meshIj->getScalarSet("$MyScalarSet")->getMin();
        data->colMap.maxValue = (float)data->meshIj->getScalarSet("$MyScalarSet")->getMax();
        data->moScalarSetIj->setScalarSet(data->meshIj->getScalarSet("$MyScalarSet")); 
      }
    }
    if (SO_KEY_PRESS_EVENT(ev, F4))
    {
      if(data->mesh)
      {
        data->colMap.minValue = (float)data->mesh->getScalarSet("$CellId")->getMin();
        data->colMap.maxValue = (float)data->mesh->getScalarSet("$CellId")->getMax();
        data->moScalarSetI->setScalarSet(data->mesh->getScalarSet("$CellId")); 
      }
      else if(data->meshIj)
      {
        data->colMap.minValue = (float)data->meshIj->getScalarSet("$CellId")->getMin();
        data->colMap.maxValue = (float)data->meshIj->getScalarSet("$CellId")->getMax();
        data->moScalarSetIj->setScalarSet(data->meshIj->getScalarSet("$CellId")); 
      }
    }
  }
}

//-----------------------------------------------------------------------------
int
main(int, char **)
{
  std::cout << "Press F1 to modify cell filters" << std::endl;
  std::cout << "Press F2 to turn on/off cell filters" << std::endl;
  std::cout << "Press F3 to map dataset binded PER NODE" << std::endl;
  std::cout << "Press F4 to map dataset binded PER CELL" << std::endl;

  MbSampleMeshBuilder<MbVec3f,float> meshBuilder1;
  MbSampleMeshBuilder<MbVec3f,float> meshBuilder2;
  MbSampleMeshBuilder<MbVec3f,float> meshBuilder3;
  MbSampleMeshBuilder<MbVec3f,float> meshBuilder4;
  
  UserData *data1, *data2, *data3, *data4;
  std::vector<FilterData> fdata(4);

  MyCellFilterI myCellFilterI;
  std::vector<MyCellFilterIj> myCellFilterIj(3);

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;
  
  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  {
    SoSeparator* sep1 = new SoSeparator;
    sep->addChild(sep1);
    MbSurfaceMeshQuadrangle<MbVec3f,float,MbVec3f>& mesh = meshBuilder1.getSurfaceMeshQuadrangle(NUMCELLI,NUMCELLJ,MbVec3f(0,0,0),MbVec3f(100/float(NUMCELLI),0,0),MbVec3f(0,100/float(NUMCELLJ),0));
    MoMesh* moMesh = new MoMesh;
    moMesh->setMesh(&mesh);
    sep1->addChild(moMesh);

    MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
    colMap->minValue = (float)mesh.getScalarSet("$MyScalarSet")->getMin();
    colMap->maxValue = (float)mesh.getScalarSet("$MyScalarSet")->getMax();
    colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
    sep1->addChild(colMap);

    // Scalar Value
    MoScalarSetI *moScalarSetI = new MoScalarSetI;
    moScalarSetI->setScalarSet(mesh.getScalarSet("$MyScalarSet"));
    sep1->addChild(moScalarSetI);

    MoCellFilter* cellFilter = new MoCellFilter;
    cellFilter->setCellFilter(&myCellFilterI);
    sep1->addChild(cellFilter);

    fdata[0].cellFilter = &myCellFilterI;
    fdata[0].moCellFilter = cellFilter;
    SoEventCallback *myCallbackNode = new SoEventCallback;
    myCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(), editCellFilter<MyCellFilterI>, &fdata[0]); 
    sep1->addChild(myCallbackNode);

    data1 = new UserData(*colMap,&mesh,NULL,moScalarSetI,NULL);
    SoEventCallback *myCallbackNode2 = new SoEventCallback;
    myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editDataSet, data1); 
    sep1->addChild(myCallbackNode2);

    MoMeshSurface *surface = new MoMeshSurface;
    surface->colorScalarSetId = 0;
    sep1->addChild(surface);
  }
  {
    SoSeparator* sep2 = new SoSeparator;
    sep->addChild(sep2);
    MbSurfaceMeshRegular<float,float,MbVec3f>& mesh = meshBuilder2.getSurfaceMeshRegular(NUMCELLI,NUMCELLJ,MbVec3f(110,0,0),MbVec3f(210,100,0));
    MoMesh* moMesh = new MoMesh;
    moMesh->setMesh(&mesh);
    sep2->addChild(moMesh);

    MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
    colMap->minValue = (float)mesh.getScalarSet("$MyScalarSet")->getMin();
    colMap->maxValue = (float)mesh.getScalarSet("$MyScalarSet")->getMax();
    colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
    sep2->addChild(colMap);

    // Scalar Value
    MoScalarSetIj *MoScalarSetIj2 = new MoScalarSetIj;
    MoScalarSetIj2->setScalarSet(mesh.getScalarSet("$MyScalarSet"));
    sep2->addChild(MoScalarSetIj2);

    MoCellFilter* cellFilter = new MoCellFilter;
    cellFilter->setCellFilter(&myCellFilterIj[0]);
    sep2->addChild(cellFilter);

    fdata[1].cellFilter = &myCellFilterIj[0];
    fdata[1].moCellFilter = cellFilter;
    SoEventCallback *myCallbackNode = new SoEventCallback;
    myCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(), editCellFilter<MyCellFilterIj>, &fdata[1]); 
    sep2->addChild(myCallbackNode);

    data2 = new UserData(*colMap,NULL,&mesh,NULL,MoScalarSetIj2);
    SoEventCallback *myCallbackNode2 = new SoEventCallback;
    myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editDataSet, data2); 
    sep2->addChild(myCallbackNode2);

    MoMeshSurface *surface = new MoMeshSurface;
    surface->colorScalarSetId = 0;
    sep2->addChild(surface);
  }
  {
    SoSeparator* sep3 = new SoSeparator;
    sep->addChild(sep3);
    MbSurfaceMeshRectilinear<float,float,MbVec3f>& mesh = meshBuilder3.getSurfaceMeshRectilinear(NUMCELLI,NUMCELLJ,330.0f,0.0f,430.0f,100.0f);
    MoMesh* moMesh = new MoMesh;
    moMesh->setMesh(&mesh);
    sep3->addChild(moMesh);

    MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
    colMap->minValue = (float)mesh.getScalarSet("$MyScalarSet")->getMin();
    colMap->maxValue = (float)mesh.getScalarSet("$MyScalarSet")->getMax();
    colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
    sep3->addChild(colMap);

    // Scalar Value
    MoScalarSetIj *MoScalarSetIj2 = new MoScalarSetIj;
    MoScalarSetIj2->setScalarSet(mesh.getScalarSet("$MyScalarSet"));
    sep3->addChild(MoScalarSetIj2);

    MoCellFilter* cellFilter = new MoCellFilter;
    cellFilter->setCellFilter(&myCellFilterIj[1]);
    sep3->addChild(cellFilter);

    fdata[2].cellFilter = &myCellFilterIj[1];
    fdata[2].moCellFilter = cellFilter;
    SoEventCallback *myCallbackNode = new SoEventCallback;
    myCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(), editCellFilter<MyCellFilterIj>, &fdata[2]); 
    sep3->addChild(myCallbackNode);

    data3 = new UserData(*colMap,NULL,&mesh,NULL,MoScalarSetIj2);
    SoEventCallback *myCallbackNode2 = new SoEventCallback;
    myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editDataSet, data3); 
    sep3->addChild(myCallbackNode2);

    MoMeshSurface *surface = new MoMeshSurface;
    surface->colorScalarSetId = 0;
    sep3->addChild(surface);
  }
  {
    SoSeparator* sep4 = new SoSeparator;
    sep->addChild(sep4);
    MbSurfaceMeshCurvilinear<MbVec3f,float,MbVec3f>& mesh = meshBuilder4.getSurfaceMeshCurvilinear(NUMCELLI,NUMCELLJ,MbVec3f(220,0,0),MbVec3f(100/float(NUMCELLI),0,0),MbVec3f(0,100/float(NUMCELLJ),0));
    MoMesh* moMesh = new MoMesh;
    moMesh->setMesh(&mesh);
    sep4->addChild(moMesh);

    MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
    colMap->minValue = (float)mesh.getScalarSet("$MyScalarSet")->getMin();
    colMap->maxValue = (float)mesh.getScalarSet("$MyScalarSet")->getMax();
    colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
    sep4->addChild(colMap);

    // Scalar Value
    MoScalarSetIj *MoScalarSetIj2 = new MoScalarSetIj;
    MoScalarSetIj2->setScalarSet(mesh.getScalarSet("$MyScalarSet"));
    sep4->addChild(MoScalarSetIj2);

    MoCellFilter* cellFilter = new MoCellFilter;
    cellFilter->setCellFilter(&myCellFilterIj[2]);
    sep4->addChild(cellFilter);

    fdata[3].cellFilter = &myCellFilterIj[2];
    fdata[3].moCellFilter = cellFilter;
    SoEventCallback *myCallbackNode = new SoEventCallback;
    myCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(), editCellFilter<MyCellFilterIj>, &fdata[3]); 
    sep4->addChild(myCallbackNode);

    data4 = new UserData(*colMap,NULL,&mesh,NULL,MoScalarSetIj2);
    SoEventCallback *myCallbackNode2 = new SoEventCallback;
    myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editDataSet, data4); 
    sep4->addChild(myCallbackNode2);

    MoMeshSurface *surface = new MoMeshSurface;
    surface->colorScalarSetId = 0;
    sep4->addChild(surface);
  }

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete data1;
  delete data2;
  delete data3;
  delete data4;
  delete viewer;
  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#if defined(_MSC_VER)
#pragma warning( pop ) 
#endif

