#include "DemoVectors.h"

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <Inventor/nodes/SoPickStyle.h>
#include <Inventor/nodes/SoSwitch.h>

#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoDataBinding.h>

//---------------------------------------------------------------------
DemoVectors::DemoVectors() : 
Demo("MeshVizXLM program showing how to display vector fields",SURFACE_MESH_UNSTRUCTURED,ALL_TYPES_NO_TETRA,
     true,MiDataSet::PER_CELL,MbVec3<size_t>(30,25,20)) ,
     m_incr(0.25f), m_thincr(0.05f), m_vec3Set(m_defaultMeshSize, MiDataSet::PER_NODE),
     m_magnitude(m_vec3Set)
{
  m_numMeshFaults = MbVec3ui(0, 0, 0);
}

//---------------------------------------------------------------------
DemoVectors::~DemoVectors()
{
}

//---------------------------------------------------------------------
void DemoVectors::keyPressed(SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();
  bool handled = false;
  bool setColorMap = false;

  // Edit vector node.
  if (SO_KEY_PRESS_EVENT(ev, T))
  {
    m_vectors->thicknessFactor.setValue(m_vectors->thicknessFactor.getValue() + m_thincr);
    handled = true;
  }
  else if (SO_KEY_PRESS_EVENT(ev, H))
  {
    m_vectors->thicknessFactor.setValue(m_vectors->thicknessFactor.getValue() - m_thincr);
    if (m_vectors->thicknessFactor.getValue() < 0)
      m_vectors->thicknessFactor = 0;
    handled = true;
  }
  else if (SO_KEY_PRESS_EVENT(ev, U)) 
  {
    m_vectors->scaleFactor.setValue(m_vectors->scaleFactor.getValue()+m_incr);
    handled = true;
  } 
  else if (SO_KEY_PRESS_EVENT(ev, D) )
  {
    m_vectors->scaleFactor.setValue(m_vectors->scaleFactor.getValue()-m_incr);
    handled = true;
  }
  else if (SO_KEY_PRESS_EVENT(ev, RIGHT_CONTROL))
  {
    m_vectors->shiftFactor.setValue(m_vectors->shiftFactor.getValue() + m_incr);
    handled = true;
  }
  else if (SO_KEY_PRESS_EVENT(ev, LEFT_CONTROL))
  {
    m_vectors->shiftFactor.setValue(m_vectors->shiftFactor.getValue() - m_incr);
    handled = true;
  }
  else if (SO_KEY_PRESS_EVENT(ev, A) )
  {
    m_vectors->arrow = !m_vectors->arrow.getValue();
    handled = true;
  }
  // edit vectors
  else
  { 
    setColorMap = true;
    if (SO_KEY_PRESS_EVENT(ev, NUMBER_1)) 
    {
      m_vec3Set.regularVec(false);
      handled = true;
    } 
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_2) )
    {
      m_vec3Set.regularVec();
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_3)) 
    {
      m_vec3Set.randomVec(false);
      handled = true;
    } 
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_4) )
    {
      m_vec3Set.randomVec();
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, C) )
    {
      m_vec3Set.setBinding(MiDataSet::PER_CELL);
      m_bindingNode->dataBinding = MoDataBinding::PER_CELL;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, N) )
    {
      m_vec3Set.setBinding(MiDataSet::PER_NODE);
      m_bindingNode->dataBinding = MoDataBinding::PER_NODE;
      handled = true;
    }
  }
  if(handled)
  {
    eventCB->setHandled();
    if (setColorMap == true)
    {
      m_colMap->minValue = (float) m_magnitude.getMin();
      m_colMap->maxValue = (float) m_magnitude.getMax();
    }
  }
   
}

//---------------------------------------------------------------------
bool DemoVectors::displayInstructions() const
{
  cout << "Press 1 to generate regular vectors" << endl;
  cout << "Press 2 to generate regular normalized vectors" << endl;
  cout << "Press 3 to randomize vectors" << endl;
  cout << "Press 4 to randomize normalized vectors" << endl;
  cout << "Press A to remove/draw arrows on vectors" << endl;
  cout << "Press C/N to display vectors binded PER_CELL/PER_NODE" << endl;
  cout << "Press U/D for scaling vectors" << endl;
  cout << "Press T/H to increase/decrease the vectors thickness" << endl;
  cout << "Press Left/right control for shifting vectors" << endl;
  return true;
}

//---------------------------------------------------------------------
void DemoVectors::getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& /*mat*/, SoDrawStyle*& /*ids*/, SoPickStyle*& ps)
{
  ds = new MoDrawStyle;
  ds->displayFaces = false;
  ps = new SoPickStyle;
  ps->style = SoPickStyle::UNPICKABLE;
}

//---------------------------------------------------------------------
void DemoVectors::insertRepresentations(SoSeparator* sep)
{
  m_bindingNode = new MoDataBinding;
  m_bindingNode->dataBinding = m_vec3Set.getBinding();
  sep->addChild(m_bindingNode);

  // Vector field
  MoVec3SetI *moVec3Set = new MoVec3SetI;
  moVec3Set->setVec3Set(&m_vec3Set);
  sep->addChild(moVec3Set);
  MoVec3SetIj *moVec3SetIj = new MoVec3SetIj;
  moVec3SetIj->setVec3Set(&m_vec3Set);
  sep->addChild(moVec3SetIj);
  MoVec3SetIjk *moVec3SetIjk = new MoVec3SetIjk;
  moVec3SetIjk->setVec3Set(&m_vec3Set);
  sep->addChild(moVec3SetIjk);

  // Color set
  MoScalarSetI *moColorSet = new MoScalarSetI;
  moColorSet->setScalarSet(&m_magnitude);
  sep->addChild(moColorSet);
  MoScalarSetIj *moColorSetIj = new MoScalarSetIj;
  moColorSetIj->setScalarSet(&m_magnitude);
  sep->addChild(moColorSetIj);
  MoScalarSetIjk *moColorSetIjk = new MoScalarSetIjk;
  moColorSetIjk->setScalarSet(&m_magnitude);
  sep->addChild(moColorSetIjk);

  // Color Map
  m_colMap = new MoPredefinedColorMapping;
  m_colMap->minValue = (float)m_magnitude.getMin();
  m_colMap->maxValue = (float)m_magnitude.getMax();
  m_colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
  sep->addChild(m_colMap);

  // Vectors
  m_vectors = new MoMeshVector;
  sep->addChild(m_vectors);
  // display vector set 1 
  m_vectors->vectorSetId = 1;
  m_vectors->scaleFactor = 1;
  m_vectors->shiftFactor = 0;
  m_vectors->thicknessFactor = 0.5f;
  // use scalar set 1 to color the vectors
  m_vectors->colorScalarSetId = 1;
  m_vectors->arrow = true;
}
