#ifndef  _WheelHexahedronCell_h
#define  _WheelHexahedronCell_h

#include <MeshVizXLM/extractors/MxHexahedronCellExtract.h>
#include <MeshVizXLM/mesh/cell/MiVolumeCell.h>

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
class WheelHexahedronCell : public MiVolumeCell
{
public:
  WheelHexahedronCell(size_t nodeId[8])
  {
    for (size_t i=0; i<8; ++i)
      m_nodeIds[i] = nodeId[i];
  }

  virtual size_t getNumEdges() const 
  {
    return 12;
  }

  virtual size_t getNumNodes() const 
  {
    return 8;
  }

  virtual size_t getNumFacets() const   {
    return 6;
  }

  /**
  * Gets the index (in the mesh) of a node
  * @param[in] node Node number (where: 0<= node < getNumNodes()).
  */
  virtual size_t getNodeIndex(size_t node) const 
  {
    return m_nodeIds[node];
  }

  virtual void getIsosurfTopology(unsigned char caseId, std::vector< std::pair<size_t,size_t> >& edgeList ) const 
  {
    return MxHexahedronCellExtract::getIsosurfTopology(caseId,edgeList);
  }

  virtual size_t appendNodesIndexOfFacet (size_t facet, std::vector<size_t>& facetNodes) const;

  virtual MbVec3d getIsoParametricCoord(size_t nodeIndex) const 
  {
    return MxHexahedronCellExtract::getIsoParametricCoord(nodeIndex);
  }

  //Reimplemented from MiCell 
  virtual void getWeight(const MbVec3d &ipcoord, std::vector<double>& weight) const
  {
    return MxHexahedronCellExtract::getWeight(ipcoord,weight);
  }

  virtual bool isPointInsideCell(const MiGeometryI& meshGeometry, const MbVec3d &point, std::vector<double>& weights) const
  {
    return MxHexahedronCellExtract::isPointInsideCell(meshGeometry,this,point,weights);
  }


protected:
  size_t m_nodeIds[8];
  //static size_t s_facetNode[6][4];
};

#endif 


