#include "WheelTopology.h"
#include "WheelHexahedronCell.h"

using std::vector;

#include <Inventor/STL/cassert>

//---------------------------------------------------------------------------------------------------------------------
WheelTopology::WheelTopology(size_t numCellI, size_t numCellJ, size_t numCellK)
: m_numCellI(numCellI),
  m_numCellJ(numCellJ),
  m_numCellK(numCellK)
{
  m_numNodeI = m_numCellI + 1;
  m_numNodeJ = m_numCellJ + 1;
  m_numNodeK = m_numCellK + 1;

  m_endNodeId =   m_numNodeI * m_numNodeJ * m_numNodeK;

  size_t i,j,k;
  size_t nodeId[8] = {0,0,0,0, 0,0,0,0};
  
  for (i=0; i<m_numCellI; ++i)
  {
    for (j=0; j<m_numCellJ; ++j)
    {
      for (k=0; k<m_numCellK; ++k)
      {
        // linear nodes id
        nodeId[0]  = getNodeIndex(i   ,  j  , k  );
        nodeId[1]  = getNodeIndex(i+1 ,  j  , k  );
        nodeId[2]  = getNodeIndex(i+1 ,  j  , k+1);
        nodeId[3]  = getNodeIndex(i   ,  j  , k+1);

        nodeId[4]  = getNodeIndex(i   ,  j+1, k  );
        nodeId[5]  = getNodeIndex(i+1 ,  j+1, k  );
        nodeId[6]  = getNodeIndex(i+1 ,  j+1, k+1);
        nodeId[7]  = getNodeIndex(i   ,  j+1, k+1);

        for (size_t kk=0; kk<8; ++kk)
          assert(nodeId[kk] < m_endNodeId);

        m_cells.push_back(WheelHexahedronCell(nodeId));
      }

    }
  }


}


