#pragma once

#include <MeshVizXLM/mapping/interfaces/MiColorMapping.h>
#include <Inventor/SbColorRGBA.h>

#include <colormapping/MbLinearColorMapping.h>
#include <vector> 

class AverageToColorMapping : public MiColorMapping < std::vector<double>, SbColorRGBA>
{
  MbLinearColorMapping<double, SbColorRGBA, float> linearColorMapping;
public:
  /**
  * Returns the color associated with the average of the given set of values.
  */
  virtual SbColorRGBA getColor(std::vector<double> values) const
  {
    // compute the average value
    double average = 0.0;
    for (size_t c = 0; c < values.size(); ++c)
      average += values[c];
    average /= values.size();

    // then use the linear colormap implementation
    return linearColorMapping.getColor(average);
  }

  /**
  * Sets the colormap levels.
  * @param colorMap is a list of pairs (value, color) sorted in increasing order of values.
  */
  void setColormap(std::vector< std::pair<double, SbColorRGBA> >& colorMap)
  {
    linearColorMapping.setColormap(colorMap);
  }

  /**
  * Returns for this colormap a unique time stamp across all colormaps in the application.
  * When the content of the colormap changes, the time stamp must increase. The time stamp
  * allows representations to identify this colormap and to be aware of any changes to it.
  * @note MxTimeStamp can be used to generate a valid time stamp.
  */
  virtual size_t getTimeStamp() const { return 1; }
};
