#pragma once

#include <MbSampleMeshBuilder.h>

#include "../../TutorialBase.h"
#include "AverageToColorMapping.h"

class SoEventCallback;
class SoNode;
class SoSwitch;

class TutorialCombineColorMapping : public TutorialBase
{
public:
  TutorialCombineColorMapping();
  ~TutorialCombineColorMapping();

  virtual void keyPressed(SoEventCallback *eventCB);

  SoNode* buildSceneGraph();

private:

  const MbVolumeMeshHexahedron<>* buildUnstMesh();
  AverageToColorMapping m_AverageToColorMapping;

  MbSampleMeshBuilder<MbVec3d,double> m_meshBuilder;
  SoSwitch* m_colorMapSwitch;
  SoSwitch* m_scalarSwitch;
  int32_t m_currentScalar;
};

class RootSphereFctor : public MbScalarFunctor<double>
{
public:
  double operator()(double x, double y, double z) const
  {
    return sqrt(x*x + y*y + z*z);
  }
  std::string getName() const { return "RootSphere"; }
};
