
#ifndef _SELECTEDCELLS_H
#define _SELECTEDCELLS_H

#include <MeshVizXLM/mapping/nodes/MoMeshCellShape.h>

#include <set> 
using namespace::std;

// This class manage the list of id of selected cell from the input mesh
class SelectedCells
{
private:
  set<size_t> m_selectedCells;

public:
  SelectedCells() {}

  bool add(size_t cellid)
  {
    std::pair<std::set<size_t>::iterator,bool> ret;
    ret = m_selectedCells.insert(cellid);
    return ret.second;
  }

  bool isCellSelected(size_t cellid) const
  {
    return m_selectedCells.find(cellid) != m_selectedCells.end();
  }
};

#endif
