
#include <MeshVizXLM/extractors/MiExtractorCallback.h>
using namespace::std;

class ExtractorCallback: public MiExtractorCallback
{
private :
  SbElapsedTime timer;
  int numCalls;
public:
  ExtractorCallback(): numCalls(0) {}

  void beginExtract(const std::string extractorName, 
    bool geomChanged, bool topoChanged, bool dataSetChanged, size_t numPhases ) 
  {
    if (numCalls == 0) 
      timer.reset();
    numCalls++;
  }
  void endExtract() 
  {
    numCalls--;
    if (numCalls == 0) 
      cout << "skin extract time: " << timer.getElapsed() << endl;
  }
  virtual bool beginPhase(size_t phaseId, std::string phaseName, size_t numIterationInPhase ) { return true; }
  virtual bool endPhase() { return true; }
  virtual bool endStep(size_t numIterationDone) { return true; }
  virtual double getEndStepCallPeriod() { return 0; }
};

