
#ifndef _SELECTEDCELLS_H
#define _SELECTEDCELLS_H

#include <MeshVizXLM/mapping/nodes/MoMeshCellShape.h>
#include <MeshVizXLM/mesh/cell/MiCellFilterI.h>
#include <MeshVizXLM/MxTimeStamp.h>

using namespace::std;

// This class manage the list of id of selected cell from the input mesh.
// As it inherits from MoMeshCellShape it is used to highlight the selected cell.
// As it implements the MiCellFilterI interface, it can be given to a MoCellFilter 
// to filter any representation of the mesh.
//
// In order to optimize the filtering process, this class uses a std::vector 
// containing as much bool flag as the number of cells in the mesh.

class SelectedCells : public MiCellFilterI, public MoMeshCellShape
{
private:
  vector<bool> m_cellFlags;
  size_t m_timeStamp;

public:
  SelectedCells(size_t numCells): m_cellFlags(numCells,false) {}

  virtual bool acceptCell(size_t cellIndex) const
  {
    return !m_cellFlags[cellIndex];
  }

  virtual size_t getTimeStamp() const 
  {
    return m_timeStamp;
  }

  void addPickedCell(size_t cellIndex)
  {
    bool isSelected = m_cellFlags[cellIndex];
    if (!isSelected)
    {
      cout << "new cell selected: " << cellIndex << endl;
      m_cellFlags[cellIndex] = true;
      cellIndices.set1Value(cellIndices.getNum(),(int)cellIndex);
      // modify the time stamp in order to let the MoCellFilter 
      // node be aware of change in the filtering.
      m_timeStamp = MxTimeStamp::getTimeStamp();
    }
  }
};

#endif
