
#ifndef _SelectedFaces_H
#define _SelectedFaces_H

#include <MeshVizXLM/mapping/nodes/MoMeshCellShape.h>
#include <set>

// This class manage the list of id of selected faces on the skin of the input mesh
class SelectedFaces: public MoMeshCellShape
{
private:
  std::set<size_t> m_SelectedFaces;

public:
  void addPickedFace(size_t faceid)
  {
    std::pair<std::set<size_t>::iterator,bool> ret;
    ret = m_SelectedFaces.insert(faceid);
    bool notFound = ret.second;
    if (notFound) 
    {
      cellIndices.set1Value(cellIndices.getNum(),(int)faceid);
      cout << "num face highlighted " << cellIndices.getNum() << endl;
    }
  }
};

#endif
