
#ifndef _SelectedFaces_H
#define _SelectedFaces_H

#include <MeshVizXLM/mapping/nodes/MoMeshCellShape.h>
#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>

#include <set> 

// This class manage the list of id of selected faces from the skin of the input mesh
class SelectedFaces: public MoMeshCellShape
{
private:
  std::set<size_t> m_selectedFaces;

  size_t getFaceId(size_t faceid, const MeXSurfaceMeshUnstructured* mexmesh, size_t cellid, const MiMesh* mimesh)
  {
    // compare the face in the extracted mesh (mexmesh) with the faces of the picked cell id in the input mesh (mimesh)
    const MiVolumeMeshUnstructured* vmesh = dynamic_cast<const MiVolumeMeshUnstructured*>(mimesh);
    const MiVolumeCell* volumecell = vmesh->getTopology().getCell(cellid);

    const MeXSurfaceCell* surfaceCell = mexmesh->getTopology().getCell(faceid);

    // we just compare to center of each face.
    MbVec3d facecenter = surfaceCell->getCenter(mexmesh->getGeometry());
    size_t relfaceid;
    for (relfaceid=0; relfaceid<volumecell->getNumFacets(); relfaceid++) 
      if (volumecell->getFacetCenter(relfaceid,vmesh->getGeometry()) == facecenter)
        return relfaceid;
    return -1;
  }

public:

  void addPickedFace(size_t faceid, const MeXSurfaceMeshUnstructured* mexmesh, size_t cellid, const MiMesh* mimesh)
  {
    std::pair<std::set<size_t>::iterator,bool> ret;
    ret = m_selectedFaces.insert(faceid);
    bool notFound = ret.second;
    if (notFound) 
    {
      cellIndices.set1Value(cellIndices.getNum(),(int)faceid);
      // find the relative face id in the input volume cell
      size_t relfaceid = getFaceId(faceid,mexmesh,cellid,mimesh);
      cout << "Added, cell " << cellid << ", face id " << relfaceid << endl;
    }
  }
};

#endif
