
#ifndef _SELECTEDCELLS_H
#define _SELECTEDCELLS_H

#include <MeshVizXLM/mapping/nodes/MoMeshCellShape.h>
#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshUnstructured.h>

#include <set> 
#include <vector>
#include <sstream>  
using namespace::std;

class SelectedSurfaceCell: public MiSurfaceCell
{
private:
  size_t m_inputCellId;
  size_t m_selectedFacetId;
  vector<size_t> m_nodeids;

public:
  SelectedSurfaceCell(size_t inputCellId, size_t selectedFacetId, const MiVolumeMeshUnstructured* volumeMesh)
    : m_inputCellId(inputCellId),m_selectedFacetId(selectedFacetId)
  {
    const MiVolumeCell* cell = volumeMesh->getTopology().getCell(inputCellId);
    cell->appendNodesIndexOfFacet(selectedFacetId,m_nodeids);
  }
  size_t getNumNodes() const 
  {
    return m_nodeids.size();
  }
  size_t getNodeIndex (size_t node) const
  {
    return m_nodeids[node];
  }
  size_t getSubTriangleNodesIndex (std::vector< size_t > &/*triangleNodeIds*/) const
  {
    return 0;
  }
  size_t getEndNodeId()
  {
    return 1 + *std::max_element(m_nodeids.begin(),m_nodeids.end());
  }
  size_t getInputCellId()
  {
    return m_inputCellId;
  }
};


// This class manage the list of id of selected faces from the input mesh
class MeshOfSelectedFaces: public MiSurfaceMeshUnstructured, public MiGeometryI, public MiSurfaceTopologyExplicitI
{
private:
  set<size_t> m_selectedCellIds;
  vector<SelectedSurfaceCell*> m_selectedFacets;
  const MiVolumeMeshUnstructured* m_vmesh;
  size_t m_endNodeId;
  size_t m_timestamp;

public:
  MeshOfSelectedFaces() {
    m_timestamp = MxTimeStamp::getTimeStamp();
    m_endNodeId = 0;
  }
  void setVolumeMesh(const MiVolumeMeshUnstructured* vmesh) 
  {
    m_vmesh = vmesh;
  }
  const MiGeometryI& getGeometry() const {
    return *this; 
  }
  const MiSurfaceTopologyExplicitI& getTopology() const { 
    return *this; 
  }

  MbVec3d getCoord(size_t nodeid) const 
  {
    return m_vmesh->getGeometry().getCoord(nodeid);
  }

  size_t getNumCells(void) const
  {
    return m_selectedFacets.size();
  }

  const MiSurfaceCell *getCell(size_t cellid) const
  {
    return m_selectedFacets[cellid];
  }

  size_t getEndNodeId(void) const
  {
    return m_endNodeId;
  }

  size_t getTimeStamp(void) const
  {
    return m_timestamp;
  }

  void addPickedFace(size_t faceid, const MeXSurfaceMeshUnstructured* mexmesh, size_t cellid, const MiMesh* mimesh)
  {
    std::pair<std::set<size_t>::iterator,bool> ret;
    ret = m_selectedCellIds.insert(faceid);
    if (ret.second == true)
    {
      // find the relative face id in the input volume cell
      const MiVolumeMeshUnstructured* vmesh = dynamic_cast<const MiVolumeMeshUnstructured*>(mimesh);
      size_t relfaceid = getFaceId(faceid,mexmesh,cellid,vmesh);
      SelectedSurfaceCell* facet = new SelectedSurfaceCell(cellid,relfaceid,vmesh);
      m_selectedFacets.push_back(facet);
      m_endNodeId = facet->getEndNodeId();
      // updating the time stamp is necessary each time this surface mesh is modified
      // in order to request a redraw of this mesh.
      m_timestamp = MxTimeStamp::getTimeStamp();
      cout << "Added, cell " << cellid << ", face id " << relfaceid << endl;
    }
  }

private:
  size_t getFaceId(size_t faceid, const MeXSurfaceMeshUnstructured* mexmesh, size_t cellid, const MiVolumeMeshUnstructured* vmesh)
  {
    // compare the face in the extracted mesh (mexmesh) with the faces of the picked cell id in the input mesh (mimesh)
    const MiVolumeCell* volumecell = vmesh->getTopology().getCell(cellid);

    const MeXSurfaceCell* surfaceCell = mexmesh->getTopology().getCell(faceid);

    // we just compare to center of each face.
    MbVec3d facecenter = surfaceCell->getCenter(mexmesh->getGeometry());
    size_t relfaceid;
    for (relfaceid=0; relfaceid<volumecell->getNumFacets(); relfaceid++) 
      if (volumecell->getFacetCenter(relfaceid,vmesh->getGeometry()) == facecenter)
        return relfaceid;
    return -1;
  }

};

#endif
