#include "TutorialBase.h"

#include <MeshVizXLM/mapping/MoMeshViz.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <Inventor/events/SoMouseButtonEvent.h>

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
using namespace std;

//---------------------------------------------------------------------
void 
keyboardCallback(void *_this, SoEventCallback *eventCB)
{
  if (SO_KEY_PRESS_EVENT(eventCB->getEvent(), M))
  {
    eventCB->setHandled();
  }
  ((TutorialBase*)_this)->keyPressed(eventCB);
}

//------------------------------------------------------------------------
// Function called each time the mouse button is pressed in the viewer window
void 
mousePressedCallback(void *_this, SoEventCallback *eventCB) 
{
  ((TutorialBase*)_this)->mousePressed(eventCB);
}

//---------------------------------------------------------------------
TutorialBase::TutorialBase(const string& demoTitle) :
  m_tutorialTitle(demoTitle)
{
}

//---------------------------------------------------------------------
TutorialBase::~TutorialBase()
{
}

//-----------------------------------------------------------------------------
int
TutorialBase::run()
{
  Widget my_window = SoXt::init(m_tutorialTitle.c_str()) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoNode* root = buildGlobalSceneGraph();

  m_viewer = new SoXtExaminerViewer(my_window);
  m_viewer->setSize(SbVec2s(1024,768));
  m_viewer->setSceneGraph(root);
  m_viewer->setTitle(m_tutorialTitle.c_str());
  m_viewer->show();
  m_viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete m_viewer;

  MoMeshViz::finish();
  SoXt::finish();
  return 0;
}

//-----------------------------------------------------------------------------
SoNode* 
TutorialBase::buildGlobalSceneGraph()
{
  SoSeparator* root = new SoSeparator;
  root->addChild(buildSceneGraph());

  // Add Callbacks
  // Mouse Moved
  SoEventCallback *mouseMovedCallbackNode= new SoEventCallback;
  mouseMovedCallbackNode->setName("Mouse_Moved");
  mouseMovedCallbackNode->addEventCallback(SoMouseButtonEvent::getClassTypeId(),mousePressedCallback, this); 
  root->addChild(mouseMovedCallbackNode);

  // Key Pressed
  SoEventCallback *keyPressedCallbackNode = new SoEventCallback;
  keyPressedCallbackNode->setName("Key_Pressed");
  keyPressedCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(),keyboardCallback,this); 
  root->addChild(keyPressedCallbackNode);

  return root;
}


//---------------------------------------------------------------------
void 
TutorialBase::viewAll()
{
  m_viewer->viewAll();
}


