#ifndef  _TutorialBase_h
#define  _TutorialBase_h

class SoEventCallback;

#include <string>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

using namespace::std;

class TutorialBase {
public:
  TutorialBase(const string&);
  virtual ~TutorialBase();
  int run();

  /* methods to implement to manage event*/
  virtual void keyPressed(SoEventCallback* /*eventCB*/) {}
  virtual void mousePressed(SoEventCallback* /*eventCB*/) {}

  /************************/

  friend void keyboardCallback(void *_this, SoEventCallback *eventCB);

protected:
  void viewAll();

private:
  SoNode* buildGlobalSceneGraph(); 
  virtual SoNode* buildSceneGraph() =0;

  std::string m_tutorialTitle;

  // scene viewer
  SoXtExaminerViewer* m_viewer;

};

#endif 
