/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MbIToIjk_h
#define  _MbIToIjk_h

//------------------------------------------------------------------------------
class MbIToIjk
{
public:
    /**
  * Constructor with storage layout KJI
  * @param numI number of elements on the first axis of the input matrix.
  * @param numJ number of elements on the second axis of the input matrix.
  */
  MbIToIjk(size_t numI, size_t numJ)
  {
    update(numI,numJ);
  }

  void update(size_t numI, size_t numJ)
  {
    m_numI = numI;
    m_numIxJ = m_numI * numJ;
  }

  /**
  * Computes the index (i,j,k) associated with the flat id
  */
  void getIjk(size_t flatId, size_t& i, size_t& j, size_t& k) const
  {
    k = flatId / m_numIxJ;
    size_t tmp = flatId % m_numIxJ;
    j = tmp / m_numI;
    i = tmp % m_numI;
  }

private:
  size_t m_numI;
  size_t m_numIxJ; // = m_numI * m_numJ (optimization)

};

#endif

