/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MBIJKTOI_H
#define _MBIJKTOI_H

#include <MeshVizXLM/mesh/MiMeshIjk.h>

/**
* @DTEXT Simple adaptor that transforms a triplet of indices (i,j,k) into a single index.
* 
* @ingroup MeshVizXLM_Implement
* 
* @DESCRIPTION Transforms matrix(N,M,L) indices into a single index. 
*/

template <MiMeshIjk::StorageLayout layout = MiMeshIjk::LAYOUT_KJI>
class MbIjkToI
{
public:
  /** 
  * Constructor 
  * @param numCellI number of cells on the first axis of the input matrix.
  * @param numCellJ number of cells on the second axis of the input matrix.
  * @param numCellK number of cells on the second axis of the input matrix.
  */
  MbIjkToI(size_t numCellI, size_t numCellJ, size_t numCellK)
  {
    m_numI = numCellI;
    m_numJ = numCellJ;
    m_numK = numCellK;
    size_t dim[3] = {numCellI,numCellJ,numCellK};
    size_t orderedDim[3];
    orderedDim[0] = dim[s_dimensionLayout[0]];
    orderedDim[1] = dim[s_dimensionLayout[1]];
    orderedDim[2] = dim[s_dimensionLayout[2]];
    m_factor[s_dimensionLayout[2]] = 1;
    m_factor[s_dimensionLayout[1]] = orderedDim[2];
    m_factor[s_dimensionLayout[0]] = orderedDim[1]*orderedDim[2];
  }

  /**
  * Computes the index associated with the triplet (i,j,k)
  */
  size_t getI(size_t i, size_t j, size_t k) const
  {
    return k*m_factor[MiMeshIjk::DIMENSION_K] + j*m_factor[MiMeshIjk::DIMENSION_J] + i*m_factor[MiMeshIjk::DIMENSION_I];
  }

protected:
  size_t m_factor[3];
  size_t m_numI, m_numJ, m_numK;
  static MiMeshIjk::Dimension s_dimensionLayout[3];
};

#endif


