/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MbSampleMeshFunctor_H
#define _MbSampleMeshFunctor_H

/**
* @DTEXT Simple functor template used to compute scalars sets and deadcells 
*        on the fly.
* 
* @ingroup MeshVizXLM_Implement
* 
*/
template < typename _ScalarT = double>
class MbScalarFunctor
{
public:
  /** custom function to apply to (x,y,z) returning a _ScalarT */
  virtual _ScalarT operator()(_ScalarT x, _ScalarT y,_ScalarT z) const =0;
  virtual std::string getName() const { return ""; }
  /** Destructor. */
  virtual ~MbScalarFunctor() {};
};

template < typename _ScalarT = double>
class MbSphereFctor : public MbScalarFunctor<_ScalarT>
{
public:
  _ScalarT operator()(_ScalarT x, _ScalarT y,_ScalarT z) const
  { return x*x + y*y + z*z;}
  std::string getName() const { return "Sphere"; }
};


template < typename _ScalarT = double>
class MbXFctor : public MbScalarFunctor<_ScalarT>
{
public:
  _ScalarT operator()(_ScalarT x, _ScalarT SO_UNUSED_PARAM(y),_ScalarT SO_UNUSED_PARAM(z)) const
  { return x;}
  std::string getName() const { return "X"; }
};

/**
* @DTEXT Simple functor template used to evaluate dead cells on the fly for unstructured meshes.
* @ingroup MeshVizXLM_Implement
*/
class MbDeadCellFctorI
{
public:
  /** custom function to compute a dead cell for the given index */
  virtual bool operator()(size_t i) const = 0;

  /** Destructor. */
  virtual ~MbDeadCellFctorI() {};
};

/**
* @DTEXT Simple functor template used to evaluate dead cells on the fly for structured surface meshes.
* @ingroup MeshVizXLM_Implement
*/
class MbDeadCellFctorIj
{
public:
  /** custom function to compute a dead cell for the given index */
  virtual bool operator()(size_t i, size_t j) const = 0;

  /** Destructor. */
  virtual ~MbDeadCellFctorIj() {};
};

/**
* @DTEXT Simple functor template used to evaluate dead cells on the fly for structured volume meshes.
* @ingroup MeshVizXLM_Implement
*/
class MbDeadCellFctorIjk
{
public:
  /** custom function to compute a dead cell for the given index */
  virtual bool operator()(size_t i, size_t j,size_t k) const = 0;

  /** Destructor. */
  virtual ~MbDeadCellFctorIjk() {};
};

/**
* @DTEXT Simple functor used to evaluate z at a given (x,y) point.
* @ingroup MeshVizXLM_Implement
*/
class MbSinGeomFunctor
{
public:
  /** custom function to compute a dead cell for the given index */
  template <typename T>
  T operator()(const MbVec3<T>& c) const { return std::sin(c[0]); }
};

/**
* @DTEXT Simple functor used to evaluate z at a given (x,y) point.
* @ingroup MeshVizXLM_Implement
*/
class MbLinearZFunctor
{
public:
  /** custom function to compute a dead cell for the given index */
  template <typename T>
  T operator()(const MbVec3<T>& c) const { return c[2]; }
};

#endif


