#include "PEBIReader.h"

#include <stdio.h>
using namespace std;

#ifdef _WIN32
#  pragma warning( push )
// disable deprecation warning for fopen and fscanf
#  pragma warning(disable:4996)
#endif

#define NUM_LAYER 10
#define MIN_2D_RANGE -0.5
#define MAX_2D_RANGE 0.5
#define LAYER_ELEVATION_FACTOR 100.0

//
PEBIReader::PEBIReader(void)
:m_mesh(new PEBIMesh(NUM_LAYER,LAYER_ELEVATION_FACTOR))
{
}

SbVec3f PEBIReader::getBBoxSize()
{
  return SbVec3f((float)(MAX_2D_RANGE - MIN_2D_RANGE), (float)(MAX_2D_RANGE - MIN_2D_RANGE), (float)(NUM_LAYER/LAYER_ELEVATION_FACTOR));
}

const SbVec3s PEBIReader::getDim()
{
  return SbVec3s(NUM_LAYER, NUM_LAYER, NUM_LAYER);
}


PEBIMesh&  
PEBIReader::generate3D(const std::string& filename){

  cout << "Reading 2D...";
  read2D(filename, true);
  cout << " ...2D done"<<endl;

  cout << "3D cells : " << m_mesh->m_topology.getNumCells() <<endl;
  cout << "nb Vertices : " << m_mesh->m_geometry.getSize() <<endl;

  return *m_mesh;

}

void PEBIReader::read2D(const std::string& filename, bool generateElevation)
{
  cout <<" Auto elevation: " << generateElevation << endl;
  FILE * voronoiData = fopen (filename.c_str() , "r");
  if (voronoiData == NULL) return;

  int dimension,  nbVextexCell, indiceVertex, vertexCount ;
  int nbCells;
  int nbVertices;
  float vx, vy, vz;

  fscanf(voronoiData , "%d",&dimension);
  fscanf(voronoiData , "%d",&nbVertices);
  m_mesh->m_geometry.resize(nbVertices);

  fscanf(voronoiData , "%d" ,&nbCells);
  cout <<" 2D cells: " << nbCells << endl;

  m_mesh->m_topology.clear();
  m_mesh->m_topology.reservePolygonSet(nbCells);

  int always1;
  fscanf(voronoiData , "%d" ,&always1); //always one (??)

  std::vector<int> ind_toRemove;
  for (int i=0; i<nbVertices; i++)
  {
    fscanf(voronoiData , "%f %f",&vx,&vy);
    if (vx > MAX_2D_RANGE|| vx < MIN_2D_RANGE || vy > MAX_2D_RANGE|| vy < MIN_2D_RANGE )
      ind_toRemove.push_back(i);
    else
    {
      vz = generateElevation * -1 * ((cos ((vx+(float)MAX_2D_RANGE)*10) / 25) + (sin ((vy+(float)MAX_2D_RANGE)*5) / 15));
      m_mesh->m_geometry.setSurfaceVertex(i,MbVec3f(vx,vy,vz));
    }
  }

  bool removeIndex = false;
  vector<size_t> cellIndices;
  std::vector<int>::const_iterator k;
  for (int i=0; i<nbCells; i++)
  {
    fscanf(voronoiData , "%d",&nbVextexCell);
    cellIndices.resize(nbVextexCell); 
    vertexCount = 0;
    for(int j=0; j<nbVextexCell; j++)
    {
      fscanf(voronoiData , "%d",&indiceVertex);
      for ( k = ind_toRemove.begin(); k != ind_toRemove.end(); ++k)
      {
        if (*k == indiceVertex)
        {
          removeIndex = true;
          break;
        }
      }
      if ((indiceVertex>= nbVertices) || removeIndex)
        removeIndex = false;
      else{
        cellIndices[vertexCount]= indiceVertex;
        vertexCount ++;
      }
    }
    if (vertexCount >= 3)
    {
      vector<size_t>::iterator it = cellIndices.begin();
      m_mesh->m_topology.addPolygonCell(it,it+vertexCount);
      vertexCount =0;
    }
  }
  ind_toRemove.clear();
  fclose(voronoiData);
}

PEBIReader::~PEBIReader(void)
{
  delete m_mesh;
}

#ifdef _WIN32
#  pragma warning( pop )
#endif

