#pragma once

#include <Inventor/STL/vector>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/SbVec.h> 

#include <mesh/volumes/PEBIMesh.h>

class PEBIReader
{
private:
  PEBIMesh *m_mesh;

	void read2D(const std::string& filename, bool generateElevation=false);


public:
	PEBIMesh& generate3D(const std::string& filename);
  SbVec3f getBBoxSize();
	const SbVec3s getDim();

	PEBIReader(void);
	~PEBIReader(void);
	
};


