#ifndef _POLYHEDRALMESHREADER_H
#define _POLYHEDRALMESHREADER_H

#define EPSILON 0.001
#define READBINARY 1
#define GENERATEMASK 1
#include <mesh/volumes/MbVolumeMeshUnstructured.h>
#include <data/MbScalarSetI.h>
#include <data/MbVec3SetI.h>
#include <Inventor/STL/vector>

class PolyhedralMeshReader {

public:

  PolyhedralMeshReader();
  ~PolyhedralMeshReader();
	MbVolumeMeshUnstructured<MbVec3d,double,MbVec3d>& readMesh(const std::string& filename);

private:
  void clear();

  int ReadHeader();
  int ReadZone();

	int ReadData();
  int ReadNumNodeFace();
  int ReadFaceNodes();
  int ReadElementFaces();

  template <typename _T>
  int read(size_t nelements,_T* databuffer, int& res_err,size_t& nelements_read);

	char* getLine();
  size_t CompareKeyword(const char* keyword);

  // mesh and scalar sets read
  MbVolumeMeshUnstructured<MbVec3d,double,MbVec3d>* m_mesh;
  std::vector< MbScalarSetI<double>* > m_scalarSets;
  MbVec3SetI<MbVec3d>* m_vec3Set;

  size_t m_numVariables;
  size_t m_numElements;
  size_t m_numNodes;
  size_t m_numFaces;
  size_t m_totalNumFaceNodes;

  size_t* m_numNodePerFaceList;
  size_t* m_faceNodeList;
  std::vector<size_t> * m_elementFaces;

  std::vector<MbVec3d> m_coord;
  std::vector<double> m_scalars;

	int m_Spec_res;
	int m_data_res;
  int m_NumFaces_res;
  int m_ElementFaces_res;
	int m_Actnum_res;

	int m_LineNumber;
	char m_Line[1024];
	FILE* fp;
};

#endif


