/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#include <cell/MbHexahedronCell.h>

using std::vector;

size_t MbHexahedronCell::s_facetNode[6][4] = 
{
  { 0,1,2,3 }, 
  { 4,7,6,5 }, 
  { 0,3,7,4 }, 
  { 1,5,6,2 }, 
  { 0,4,5,1 }, 
  { 3,2,6,7 }  
};

//-----------------------------------------------------------------------------
unsigned char
MbHexahedronCell::getMarchingCaseId(std::vector<bool> &nodesSign, size_t beginNodeId) const
{
  unsigned char case_id = 0;

  if (nodesSign[m_nodeIds[0]-beginNodeId]) case_id = 1;
  if (nodesSign[m_nodeIds[1]-beginNodeId]) case_id |= 2;
  if (nodesSign[m_nodeIds[2]-beginNodeId]) case_id |= 4;
  if (nodesSign[m_nodeIds[3]-beginNodeId]) case_id |= 8;
  if (nodesSign[m_nodeIds[4]-beginNodeId]) case_id |= 16;
  if (nodesSign[m_nodeIds[5]-beginNodeId]) case_id |= 32;
  if (nodesSign[m_nodeIds[6]-beginNodeId]) case_id |= 64;
  if (nodesSign[m_nodeIds[7]-beginNodeId]) case_id |= 128;

  if (case_id == 255) case_id = 0;
  return case_id;
}

