/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MBPOLYGONCELL_H
#define _MBPOLYGONCELL_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#endif

#include <MeshVizXLM/extractors/MxPolygonCellExtract.h>
#include <MeshVizXLM/mesh/cell/MiSurfaceCell.h>
#include <MbMeshVizImpl.h>

/**
* @DTEXT Build a polygonal cell.
* 
* @ingroup MeshVizXLM_Implement_Cell
*/
class MbPolygonCell : virtual public MiSurfaceCell
{
public:

  /** 
  * Construct a polygon defined by its list of indices.
  */
  template <typename _NodeIdIter>
  MbPolygonCell(_NodeIdIter beginId, _NodeIdIter endId);

  /**
  * Gets the surface of the polygon. 
  */
  double getArea(const MiGeometryI* meshGeometry) const;

  /**
  * Gets the number of edges.
  */
  virtual size_t getNumEdges() const; 

  /**
  * Gets the number of nodes.
  */
  virtual size_t getNumNodes() const; 

  virtual size_t getNodeIndex(size_t nod) const;

  /**
  * Checks if a point is inside or outside a cell.
  */
  virtual bool isPointInsideCell(const MiGeometryI& meshGeometry, const MbVec3d &point, std::vector<double>& weights) const;

  /**
  * Gets the relative size of the cell
  */
  virtual double getRelativeSize(const MiGeometryI* meshGeometry) const;


protected:
  /**
  * Defines a specialized output on stream for MbPolygonCell
  */
  virtual std::ostream& toStream(std::ostream& s) const;

  std::vector<size_t> m_nodeIds;

};

//-----------------------------------------------------------------------------
template <typename _NodeIdIter>
inline
MbPolygonCell::MbPolygonCell(_NodeIdIter beginId, _NodeIdIter endId)
{
  m_nodeIds.assign(beginId,endId);
}

//-----------------------------------------------------------------------------
inline bool 
MbPolygonCell::isPointInsideCell(const MiGeometryI& meshGeometry, const MbVec3d &point, std::vector<double>& weights) const
{
  return MxPolygonCellExtract::isPointInsideCell(meshGeometry,this,point,weights);
}

//-----------------------------------------------------------------------------
inline double 
MbPolygonCell::getRelativeSize(const MiGeometryI* meshGeometry) const
{
  return MxPolygonCellExtract::getLongestEdgeLength(*meshGeometry,this);
}

//-----------------------------------------------------------------------------
inline double 
MbPolygonCell::getArea(const MiGeometryI* meshGeometry) const
{
  return MxPolygonCellExtract::getArea(*meshGeometry,this);
}

//-----------------------------------------------------------------------------
inline size_t 
MbPolygonCell::getNumEdges() const
{
  return m_nodeIds.size();
}

//-----------------------------------------------------------------------------
inline size_t 
MbPolygonCell::getNumNodes() const
{
  return m_nodeIds.size();
}

//-----------------------------------------------------------------------------
inline size_t 
MbPolygonCell::getNodeIndex(size_t nod) const
{
  return m_nodeIds[nod];
}

//-----------------------------------------------------------------------------
inline std::ostream& 
MbPolygonCell::toStream(std::ostream& s) const
{
  s << "MbPolygonCell (";
  size_t numNodes = m_nodeIds.size();
  for (size_t i=0; i<numNodes-1; ++i)
    s << m_nodeIds[i] << ",";
  s << m_nodeIds[numNodes-1];
  s << ")";
  return s;
}

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif


