/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#include <cell/MbPyramidCell.h>

using std::vector;


size_t MbPyramidCell::s_facetNode[5][4] = 
{
  { 0,1,2,3 }, 
  { 0,4,1, (size_t)-1 },
  { 1,4,2, (size_t)-1 },
  { 2,4,3, (size_t)-1 }, 
  { 3,4,0, (size_t)-1 }  
};

//-----------------------------------------------------------------------------
unsigned char 
MbPyramidCell::getMarchingCaseId(std::vector<bool> &nodesSign, size_t beginNodeId) const
{
  unsigned char case_id = 0;

  if (nodesSign[m_nodeIds[0]-beginNodeId]) case_id = 1;
  if (nodesSign[m_nodeIds[1]-beginNodeId]) case_id |= 2;
  if (nodesSign[m_nodeIds[2]-beginNodeId]) case_id |= 4;
  if (nodesSign[m_nodeIds[3]-beginNodeId]) case_id |= 8;
  if (nodesSign[m_nodeIds[4]-beginNodeId]) case_id |= 16;

  if (case_id == 31) case_id = 0;
  return case_id;
}

//-----------------------------------------------------------------------------
size_t 
MbPyramidCell::appendNodesIndexOfFacet (size_t facet, std::vector<size_t>& facetNodes) const
{
  switch (facet) 
  { 
  case 0:
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][0]]);
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][1]]);
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][2]]);
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][3]]);
    return 4;
    break;
  default:
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][0]]);
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][1]]);
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][2]]);
    return 3;
    break;
  }
}


