/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#include <cell/MbTetrahedronCell.h>

using std::vector;

size_t MbTetrahedronCell::s_facetNode[4][3] = 
{
  { 0,1,2 },
  { 0,2,3 },
  { 0,3,1 },
  { 1,3,2 }
};

//-----------------------------------------------------------------------------
unsigned char 
MbTetrahedronCell::getMarchingCaseId(std::vector<bool> &nodesSign, size_t beginNodeId) const
{
  unsigned char case_id = 0;

  if (nodesSign[m_nodeIds[0]-beginNodeId]) case_id = 1;
  if (nodesSign[m_nodeIds[1]-beginNodeId]) case_id |= 2;
  if (nodesSign[m_nodeIds[2]-beginNodeId]) case_id |= 4;
  if (nodesSign[m_nodeIds[3]-beginNodeId]) case_id |= 8;

  if (case_id == 15) case_id = 0;
  return case_id;
}

