/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#include <cell/MbVoxelCell.h>

//------------------------------------------------------------------------------
MbVoxelCell::MbVoxelCell(size_t n0, size_t n1, size_t n2, size_t n3, size_t n4,
                         size_t n5, size_t n6, size_t n7)
                         :MbHexahedronCell(n0,n1,n2,n3,n4,n5,n6,n7)
{
}

//------------------------------------------------------------------------------
double
MbVoxelCell::getVolume(const MiGeometryI *meshGeometry) const
{
  MbVec3d dimension = meshGeometry->getCoord(m_nodeIds[6]) - meshGeometry->getCoord(m_nodeIds[0]);

  return dimension[0]*dimension[1]*dimension[2];
}

//------------------------------------------------------------------------------
double
MbVoxelCell::getRelativeSize(const MiGeometryI* meshGeometry) const
{
  double len, max_len=0;
  MbVec3d cellCoords[4];

  // store the wedge coordinates
  cellCoords[0] = meshGeometry->getCoord(m_nodeIds[0]);
  cellCoords[1] = meshGeometry->getCoord(m_nodeIds[1]);
  cellCoords[2] = meshGeometry->getCoord(m_nodeIds[3]);
  cellCoords[3] = meshGeometry->getCoord(m_nodeIds[4]);

  len = (cellCoords[0]-cellCoords[1]).length(); if (len>max_len) max_len=len;
  len = (cellCoords[0]-cellCoords[2]).length(); if (len>max_len) max_len=len;
  len = (cellCoords[0]-cellCoords[3]).length(); if (len>max_len) max_len=len;

  return max_len;
}


