/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MBVOXELCELL_H
#define _MBVOXELCELL_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/cell/MiVolumeCell.h>
#include <cell/MbHexahedronCell.h>
#include <MbMeshVizImpl.h>

/**
 * @DTEXT  Defines a voxel cell of a volume mesh.
 * 
 * @ingroup MeshVizXLM_Implement_Cell
 * 
 * @DESCRIPTION
 *    A voxel cell is a parallelepipede of which faces are orthogonal to X, Y, Z axes.
 *    with n0 the closest to the origin.
 *    Each facet is a rectangle not necessarily a square.
 *    The 4 first indices defines a face of the voxel cell. The 4 last indices defines
 *    the opposite face.
 * 
 *    Facets and nodes are numbered as following :
 * \verbatim
                         n3----------n2   facet 0 = 0123
                         /|          /|   facet 1 = 4765
                       /  |        /  |   facet 2 = 0374
                     /    |      /    |   facet 3 = 1562
                   n7---------n6      |   facet 4 = 0451
                    |     |    |      |   facet 5 = 3267
                    |    n0----|-----n1
                    |    /     |     /
                    |  /       |   /
                    |/         | /
                   n4---------n5

   \endverbatim
 * 
 *   - The first face is defined by the first 4 nodes of the cell.
 *   - The second face is defined by the first 4 nodes of the cell.
 *   - The other faces are numbered as above.
 
 *    This numerotation must be respected to have the right result returned 
 *    by getVolume()
 * 
 */

class MbVoxelCell : virtual public MbHexahedronCell
{
public:

  /**
  * Construct an empty voxel cell
  */
  MbVoxelCell():MbHexahedronCell(0,0,0,0,0,0,0,0) {}
  
  /**
  * Construct a voxel cell
  */
  MbVoxelCell(size_t n0, size_t n1, size_t n2, size_t n3,
              size_t n4, size_t n5, size_t n6, size_t n7);

  /**
  * Gets the volume of the cell.
  */
  double getVolume(const MiGeometryI* meshGeometry) const;

  virtual double getRelativeSize(const MiGeometryI* meshGeometry) const;

protected:
  /**
  * Defines a specialized output on stream for MbHexahedronCell
  */
  virtual std::ostream& toStream(std::ostream& s) const;

};

//-----------------------------------------------------------------------------
inline std::ostream& 
MbVoxelCell::toStream(std::ostream& s) const
{
  s << "MbVoxelCell (" << 
    m_nodeIds[0] << "," << 
    m_nodeIds[1] << "," << 
    m_nodeIds[2] << "," << 
    m_nodeIds[3] << "," << 
    m_nodeIds[4] << "," << 
    m_nodeIds[5] << "," << 
    m_nodeIds[6] << "," << 
    m_nodeIds[7] <<  
    ")";
  return s;
}

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif

