/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#include <cell/MbWedgeCell.h>

using std::vector;


size_t MbWedgeCell::s_facetNode[5][4] = 
{
  { 0,1,2, (size_t)-1 }, 
  { 3,5,4, (size_t)-1 },
  { 0,2,5,3 }, 
  { 1,4,5,2 }, 
  { 0,3,4,1 }  
};

//-----------------------------------------------------------------------------
unsigned char 
MbWedgeCell::getMarchingCaseId(std::vector<bool> &nodesSign, size_t beginNodeId) const
{
  unsigned char case_id = 0;

  if (nodesSign[m_nodeIds[0]-beginNodeId]) case_id = 1;
  if (nodesSign[m_nodeIds[1]-beginNodeId]) case_id |= 2;
  if (nodesSign[m_nodeIds[2]-beginNodeId]) case_id |= 4;
  if (nodesSign[m_nodeIds[3]-beginNodeId]) case_id |= 8;
  if (nodesSign[m_nodeIds[4]-beginNodeId]) case_id |= 16;
  if (nodesSign[m_nodeIds[5]-beginNodeId]) case_id |= 32;

  if (case_id == 63) case_id = 0;
  return case_id;
}

//-----------------------------------------------------------------------------
size_t 
MbWedgeCell::appendNodesIndexOfFacet (size_t facet, std::vector<size_t>& facetNodes) const
{
  switch (facet) 
  { 
  case 0:
  case 1:
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][0]]);
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][1]]);
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][2]]);
    return 3;
    break;
  default:
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][0]]);
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][1]]);
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][2]]);
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][3]]);
    return 4;
    break;
  }
}


