#include "PEBICell.h"
#include <Inventor/STL/cassert>

using std::vector;

const size_t* PEBICell::m_numNodeShift = NULL;

//-----------------------------------------------------------------------------
size_t 
PEBICell::getNodeIndex(size_t nod) const
{
  size_t id = nod % m_polygon.getNumNodes();
  size_t offset = (nod == id) ? 0 : 1;
  return m_polygon.getNodeIndex(id) + (m_layer + offset)*(*m_numNodeShift);
}

//-----------------------------------------------------------------------------
size_t 
PEBICell::appendNodesIndexOfFacet(size_t facet, std::vector<size_t>& facetNodes) const
{
  size_t numNodes = m_polygon.getNumNodes();
  size_t offset = m_layer * (*m_numNodeShift);
  if ( facet < 2 ) //upper and lower facets
  {
    for ( size_t i = 0; i < numNodes; ++i)
      facetNodes.push_back(m_polygon.getNodeIndex(i) + offset + facet*(*m_numNodeShift));
  }
  else //side facets
  {
    size_t sidef = facet - 2;
    assert( sidef < numNodes );
    facetNodes.push_back(m_polygon.getNodeIndex(sidef) + offset); 
    facetNodes.push_back(m_polygon.getNodeIndex((sidef+1)%numNodes) + offset);
    facetNodes.push_back(m_polygon.getNodeIndex((sidef+1)%numNodes) + offset + (*m_numNodeShift));
    facetNodes.push_back(m_polygon.getNodeIndex(sidef) + offset + (*m_numNodeShift)); 
    
  }
  return facetNodes.size();
}


size_t 
PEBICell::appendLocalNodesIndexOfFacet(size_t facet, std::vector<size_t>& facetNodes) const
{
  size_t numNodes = m_polygon.getNumNodes();
  if ( facet == 0) {//upper facet
    for ( size_t i = 0; i < numNodes; ++i)
		facetNodes.push_back(i);
  }
  else if ( facet == 1 ) //lower facet
  {
    for ( size_t i = 0; i < numNodes; ++i)
		facetNodes.push_back(numNodes+i);
  }
  else
  {
    size_t sidef = facet - 2;
    assert( sidef < numNodes );
    if ( sidef < numNodes-1 ) 
    { //side facet (except last one)
      facetNodes.push_back(sidef); 
      facetNodes.push_back(sidef+1);
      facetNodes.push_back(sidef+1+numNodes);
      facetNodes.push_back(sidef+numNodes);
    }
   else 
   { //last side facet
    facetNodes.push_back(sidef); 
    facetNodes.push_back(0);
    facetNodes.push_back(numNodes);
    facetNodes.push_back(sidef+numNodes); 
   }
  }

  return facetNodes.size();
}


