#ifndef _PEBICELL_H_
#define _PEBICELL_H_

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#pragma warning(disable:4251)
#endif

#include <MeshVizXLM/mesh/cell/MiVolumeCell.h>
#include <MeshVizXLM/mesh/cell/MiSurfaceCell.h>
#include <MeshVizXLM/extractors/MxPolyhedronCellExtract.h>

// In this type of mesh, each cell contains only its i,j,k index and eight 3D points 
class PEBICell : public MiVolumeCell 
{
public:
  PEBICell(const MiSurfaceCell& polygon, size_t layer)
    : m_polygon(polygon), m_layer(layer) {}
  
  /**
  * Gets the number of edges.
  */
  size_t getNumEdges() const
  {
    return m_polygon.getNumNodes()*3;
  }

  /**
  * Gets the number of nodes.
  */
  size_t getNumNodes() const
  {
    return m_polygon.getNumNodes()*2;
  }

  /**
  * Gets the index (in the mesh) of a nod (nod must be >=0 and < getNumNodes()).
  */
  size_t getNodeIndex(size_t nod) const;

  /**
  * Gets the number of facets.
  */
  size_t getNumFacets() const
  {
    return m_polygon.getNumNodes() + 2;
  }

  size_t appendNodesIndexOfFacet (size_t facet, std::vector<size_t>& facetNodes) const ;

  size_t appendLocalNodesIndexOfFacet (size_t facet, std::vector<size_t>& facetNodes) const;

  virtual void getIsosurfTopology(unsigned char /*caseId*/, std::vector< std::pair<size_t,size_t> >& edgeList ) const
  {
    edgeList.clear();
  }

  //Reimplemented from MiCell 
  virtual void getWeight(const MiGeometryI& meshGeometry,const MbVec3d &point, std::vector<double>& weights) const 
  {
    return MxPolyhedronCellExtract::getWeight(meshGeometry,this,point,weights);
  }

  /**
  * Checks if a point is inside or outside a cell.
  */
  bool isPointInsideCell(const MiGeometryI& meshGeometry, const MbVec3d &point, std::vector<double>& weights) const
  {
    return MxPolyhedronCellExtract::isPointInsideCell(meshGeometry,this,point,weights);
  }

  /**
  * Gets the relative size of the cell
  */
  double getRelativeSize(const MiGeometryI* meshGeometry) const
  {
    return MxPolyhedronCellExtract::getLongestDistance(*meshGeometry,this);
  }

  static void setShift(const size_t& numNodeShift)
  {
    m_numNodeShift = &numNodeShift;
  }

private:
  const MiSurfaceCell& m_polygon;
  static const size_t* m_numNodeShift;
  size_t m_layer;

};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif


