#ifndef  _QuadraticLineCell_h
#define  _QuadraticLineCell_h

#include <MeshVizXLM/mesh/cell/MiLineCell.h>

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
class QuadraticLineCell : public MiLineCell
{
public:
  QuadraticLineCell(size_t nodeId0, size_t nodeId1, size_t nodeId2) 
  {
    m_nodeIds[0] = nodeId0;
    m_nodeIds[1] = nodeId1;
    m_nodeIds[2] = nodeId2;
  }

  virtual size_t getNumEdges() const 
  {
    return 1;
  }

  virtual size_t getNumNodes() const 
  {
    return 3;
  }

  /**
  * Gets the index (in the mesh) of a node
  * @param[in] node Node number (where: 0<= node < getNumNodes()).
  */
  virtual size_t getNodeIndex(size_t node) const 
  {
    return m_nodeIds[node];
  }

  virtual MbVec3d getIsoParametricCoord(size_t nodeIndex) const 
  {
    switch (nodeIndex)
    {
    case 0: return MbVec3d(0,0,0);
    case 1: return MbVec3d(1,0,0);
    case 2: 
    default: return MbVec3d(0.5,0,0);
    }
  }

  virtual void getWeight(const MbVec3d &ipcoord, std::vector<double>& weight) const 
  {
    double r = ipcoord[0];
    weight[0] = 2*(r-0.5)*(r-1);
    weight[1] = 2*r*(r-0.5);
    weight[2] = 4*r*(1-r);
  }

  virtual size_t getSubEdgeNodesIndex(std::vector<size_t>& edgeNodeIds) const 
  {
    edgeNodeIds.resize(4);
    edgeNodeIds[0] = 0;
    edgeNodeIds[1] = 2;
    edgeNodeIds[2] = 2;
    edgeNodeIds[3] = 1;
    return 2;
  }


  //virtual void getWeight(const MiGeometryI& meshGeometry, const MbVec3d &point, std::vector<double>& weights) const
private:
  size_t m_nodeIds[3];


};

#endif 


