#ifndef  _QuadraticQuadrangle9Cell_h
#define  _QuadraticQuadrangle9Cell_h

#include <MeshVizXLM/mesh/cell/MiSurfaceCell.h>
#include <MeshVizXLM/extractors/MxQuadrangle9CellExtract.h>

//-----------------------------------------------------------------------------
class QuadraticQuadrangle9Cell : public MiSurfaceCell
{
public:
  QuadraticQuadrangle9Cell(size_t nodeId0, size_t nodeId1, size_t nodeId2, size_t nodeId3, 
                          size_t nodeId4, size_t nodeId5, size_t nodeId6, size_t nodeId7,
                          size_t nodeId8) 
  {
    m_nodeIds[0] = nodeId0;
    m_nodeIds[1] = nodeId1;
    m_nodeIds[2] = nodeId2;
    m_nodeIds[3] = nodeId3;
    m_nodeIds[4] = nodeId4;
    m_nodeIds[5] = nodeId5;
    m_nodeIds[6] = nodeId6;
    m_nodeIds[7] = nodeId7;
    m_nodeIds[8] = nodeId8;
  }

  virtual size_t getNumEdges() const 
  {
    return 4;
  }

  virtual size_t getNumNodes() const 
  {
    return 9;
  }

  virtual size_t getNodeIndex(size_t node) const 
  {
    return m_nodeIds[node];
  }

  virtual MbVec3d getIsoParametricCoord(size_t nodeIndex) const 
  {
    return MxQuadrangle9CellExtract::getIsoParametricCoord(nodeIndex);
  }

  virtual void getWeight(const MbVec3d &ipcoord, std::vector<double>& weight) const
  {
    MxQuadrangle9CellExtract::getWeight(ipcoord,weight);
  }

  virtual size_t getSubTriangleNodesIndex(std::vector<size_t>& triangleNodeIds) const 
  {
    return MxQuadrangle9CellExtract::getSubTriangleNodesIndex(triangleNodeIds);
  }

protected:
  size_t m_nodeIds[9];
};

#endif 


