#ifndef  _QuadraticTriangle6Cell_h
#define  _QuadraticTriangle6Cell_h

#include <MeshVizXLM/mesh/cell/MiSurfaceCell.h>
#include <MeshVizXLM/extractors/MxTriangle6CellExtract.h>

//-----------------------------------------------------------------------------
class QuadraticTriangle6Cell : public MiSurfaceCell
{
public:
  QuadraticTriangle6Cell(size_t nodeId0, size_t nodeId1, size_t nodeId2, size_t nodeId3, size_t nodeId4, size_t nodeId5) 
  {
    m_nodeIds[0] = nodeId0;
    m_nodeIds[1] = nodeId1;
    m_nodeIds[2] = nodeId2;
    m_nodeIds[3] = nodeId3;
    m_nodeIds[4] = nodeId4;
    m_nodeIds[5] = nodeId5;
  }

  virtual size_t getNumEdges() const 
  {
    return 3;
  }

  virtual size_t getNumNodes() const 
  {
    return 6;
  }

  virtual size_t getNodeIndex(size_t node) const 
  {
    return m_nodeIds[node];
  }

  virtual MbVec3d getIsoParametricCoord(size_t nodeIndex) const 
  {
    return MxTriangle6CellExtract::getIsoParametricCoord(nodeIndex);
  }

  virtual void getWeight(const MbVec3d &ipcoord, std::vector<double>& weight) const 
  {
    return MxTriangle6CellExtract::getWeight(ipcoord,weight);
  }


  virtual size_t getSubTriangleNodesIndex(std::vector<size_t>& triangleNodeIds) const 
  {
    return MxTriangle6CellExtract::getSubTriangleNodesIndex(triangleNodeIds);
  }

private:
  size_t m_nodeIds[6];
};

#endif 


