/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MBDATASET__H
#define _MBDATASET__H

#include <data/MbTypedDataSet.h>
#include <MeshVizXLM/MbVec3.h>

//-----------------------------------------------------------------------------
/**
* @DTEXT Generic data set implementation.
* 
* @ingroup MeshVizXLM_Implement_Data
* 
* @DESCRIPTION
*    A generic abstract template interface for a data set usable in any extract or geometry of a mesh.
* 
*/

template <typename _T>
class MbDataSet: public MbTypedDataSet<_T>
{
public:
  /**
  * Constructor for an empty default dataset. @BR
  * Initializes name to empty string, data binding to PER_NODE and
  * timestamp to 1.
  */
  MbDataSet() {}

  /**
  * Constructor for dataset with specific name and
  * specific data binding. Initializes timestamp to 1.
  */
  MbDataSet(const std::string& name, MiDataSet::DataBinding binding) : MbTypedDataSet<_T>(name, binding) {}

  /**
   * Returns the minimum value of this set.
   */
  virtual _T getMin() const { return (_T) 0.; }
  
  /**
   * Returns the maximum value of this set.
   */
  virtual _T getMax() const { return (_T) 0.; }

};

typedef MbDataSet<double>  MbScalardSet;
typedef MbDataSet<MbVec3d> MbVec3dSet;

#endif


