/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MBSCALARSETIJK_H
#define  _MBSCALARSETIJK_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>

#include <data/MbDataSet.h>
#include <MbIjkToI.h>
#include <MbMeshVizImpl.h>


#include <Inventor/STL/vector>
#include <Inventor/STL/iostream>
#include <Inventor/STL/sstream>
#include <Inventor/STL/algorithm>

/**
 * @DTEXT  Defines a set of scalars for Ijk volumes.
 * 
 * @ingroup MeshVizXLM_Implement_Data
 * 
 * @DESCRIPTION

 * 
 */
template <typename _T=double, MiMeshIjk::StorageLayout _Layout = MiMeshIjk::LAYOUT_KJI>
class MbScalarSetIjk : virtual public MiScalardSetIjk, public MbScalardSet, private MbIjkToI<_Layout>
{
public:
  //@{
  /**
  * Constructor for an empty default dataset.
  * This dataset has a default name depending on the number of instances created.
  * Its binding is set to PER_NODE by default.
  */
  MbScalarSetIjk();
  MbScalarSetIjk(size_t numI, size_t numJ, size_t numK);

  MbScalarSetIjk(size_t numI, size_t numJ, size_t numK, 
                 const std::string& name, DataBinding binding=PER_NODE);
  //@}

  /**
  * Returns the (i,j,k)-th value of this set.
  */
  double get(size_t i, size_t j, size_t k) const;

  /**
  * Sets the (i,j,k)-th value of this set.
  */
  void set(size_t i, size_t j, size_t k, const _T& data);

  virtual MiMeshIjk::StorageLayout getStorageLayout() const { return _Layout; }

  //@{
  /**
  * Returns the number of values in this set.
  */
  virtual void getSize(size_t& sizeI, size_t& sizeJ, size_t& sizeK) const;
  virtual void setSize(size_t sizeI, size_t sizeJ, size_t sizeK);
  //@}

  /**
  * Returns the min of this set.
  */
  virtual double getMin() const;
  /**
  * Returns the max of this set.
  */
  virtual double getMax() const;

protected:
  /**
  * Defines a specialized output on stream for MbScalarSet
  */
  virtual std::ostream& toStream(std::ostream& s) const;

  std::vector<_T> m_scalars;

  static size_t s_numInstance;
};

typedef MbScalarSetIjk<double>  MbScalardSetIjk;

template <typename _T, MiMeshIjk::StorageLayout _Layout>
size_t MbScalarSetIjk<_T,_Layout>::s_numInstance = 0;

//-----------------------------------------------------------------------------
template <typename _T, MiMeshIjk::StorageLayout _Layout>
inline 
MbScalarSetIjk<_T,_Layout>::MbScalarSetIjk() :
  MbIjkToI<_Layout>(0,0,0)
{
  std::ostringstream defName; 
  defName << "MbScalarSet_#" << s_numInstance++;
  m_name = defName.str();
}

//-----------------------------------------------------------------------------
template <typename _T, MiMeshIjk::StorageLayout _Layout>
inline 
MbScalarSetIjk<_T,_Layout>::MbScalarSetIjk(size_t numI, size_t numJ, size_t numK) :
  MbIjkToI<_Layout>(numI,numJ,numK)
{
  std::ostringstream defName; 
  defName << "MbScalarSet_#" << s_numInstance++;
  m_name = defName.str();
  m_scalars.resize(this->m_numI*this->m_numJ*this->m_numK);
}

//-----------------------------------------------------------------------------
template <typename _T, MiMeshIjk::StorageLayout _Layout>
inline 
MbScalarSetIjk<_T,_Layout>::MbScalarSetIjk(size_t numI, size_t numJ, size_t numK, 
                                   const std::string& name,
                                   DataBinding binding) 
: MbScalardSet(name,binding), MbIjkToI<_Layout>(numI,numJ,numK)
{
  m_scalars.resize(this->m_numI*this->m_numJ*this->m_numK);
  s_numInstance++;
}

//-----------------------------------------------------------------------------
template <typename _T, MiMeshIjk::StorageLayout _Layout>
double
MbScalarSetIjk<_T,_Layout>::get(size_t i, size_t j, size_t k) const
{
  return (double)m_scalars[this->getI(i,j,k)]; 
}

template <typename _T, MiMeshIjk::StorageLayout _Layout>
void
MbScalarSetIjk<_T,_Layout>::set(size_t i, size_t j, size_t k, const _T& data)
{
  if (i<this->m_numI && j<this->m_numJ && k<this->m_numK) 
  {
    m_scalars[this->getI(i,j,k)] = data;
    m_timeStamp = MxTimeStamp::getTimeStamp();
  }
}

//-----------------------------------------------------------------------------
template <typename _T, MiMeshIjk::StorageLayout _Layout>
void
MbScalarSetIjk<_T,_Layout>::getSize(size_t& i, size_t& j, size_t& k) const 
{
  i = this->m_numI;
  j = this->m_numJ;
  k = this->m_numK;
}

template <typename _T, MiMeshIjk::StorageLayout _Layout>
void
MbScalarSetIjk<_T,_Layout>::setSize(size_t i, size_t j, size_t k) 
{
  this->m_numI = i;
  this->m_numJ = j;
  this->m_numK = k;
  m_scalars.resize(i*j*this->m_numK);
  m_timeStamp = MxTimeStamp::getTimeStamp();
}

//-----------------------------------------------------------------------------
template <typename _T, MiMeshIjk::StorageLayout _Layout>
double
MbScalarSetIjk<_T,_Layout>::getMin() const
{
  typename std::vector<_T>::const_iterator itmin = std::min_element(m_scalars.begin(),m_scalars.end());
  return (double)(*itmin);
}


//-----------------------------------------------------------------------------
template <typename _T, MiMeshIjk::StorageLayout _Layout>
double
MbScalarSetIjk<_T,_Layout>::getMax() const
{
  typename std::vector<_T>::const_iterator itmax = std::max_element(m_scalars.begin(),m_scalars.end());
  return (double)(*itmax);
}


//-----------------------------------------------------------------------------
template <typename _T, MiMeshIjk::StorageLayout _Layout>
std::ostream& 
MbScalarSetIjk<_T,_Layout>::toStream(std::ostream& s) const
{
  s << "# scalarset name" << std::endl; 
  s << getName() << std::endl; 
  s << "# scalarset size" << std::endl;
  s << this->m_numI << "," << this->m_numJ << "," << this->m_numK << std::endl;
  for (size_t i=0; i< this->m_numI; ++i) 
    for (size_t j=0; j< this->m_numJ; ++j)
      for (size_t k=0; k< this->m_numK; ++k)
      s << "value(" << i << "," << j << "," << k << ")=" << get(i,j,k) << std::endl;

  return s;
}

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif








