#include <data/MbStringSetI.h>

size_t MbStringSetI::s_numInstance = 0;

MbStringSetI::MbStringSetI(size_t size)
  : m_strings(size)
{
  std::ostringstream defName;
  defName << "MbStringSet_#" << s_numInstance++;
  m_name = defName.str();

  for (size_t n = 0; n < size; ++n)
  {
    std::ostringstream istring;
    istring << "id:" << n;
    m_strings[n] = istring.str();
  }
}

MbStringSetI::MbStringSetI(const std::string& name, MiDataSet::DataBinding binding, size_t size)
  : MbStringSet(name, binding)
  , m_strings(size)
{
  s_numInstance++;

  for (size_t n = 0; n < size; ++n)
  {
    std::ostringstream istring;
    istring << "id:" << n;
    m_strings[n] = istring.str();
  }
}

MbStringSetI::MbStringSetI(const MeXStringSetI& stringset)
  : MbStringSet(stringset.getName(), stringset.getBinding())
  , m_strings(stringset.getSize())
{
  s_numInstance++;

  for (size_t n = 0; n < m_strings.size(); ++n)
    m_strings[n] = stringset.get(n);
}

std::string
MbStringSetI::get(size_t i) const
{
  return m_strings[i];
}

size_t
MbStringSetI::getSize() const
{
  return m_strings.size();
}

std::ostream&
MbStringSetI::toStream(std::ostream& s) const
{
  s << "# stringset name" << std::endl;
  s << getName() << std::endl;
  s << "# stringset size" << std::endl;
  s << getSize() << std::endl;
  for (size_t i=0; i<m_strings.size(); ++i)
    s << m_strings[i] << std::endl;

  return s;
}
