#include <data/MbStringSetIj.h>

size_t MbStringSetIj::s_numInstance = 0;

MbStringSetIj::MbStringSetIj(size_t sizeI, size_t sizeJ)
  : MbIjToI(sizeI)
  , m_numJ(sizeJ)
{
  std::ostringstream defName;
  defName << "MbStringSet_#" << s_numInstance++;
  m_name = defName.str();

  m_strings.resize(this->m_numI*this->m_numJ);
  for (size_t i = 0; i < this->m_numI; ++i)
    for (size_t j = 0; j < this->m_numJ; ++j)
    {
      std::ostringstream istring;
      istring << "id:" << i << ", " << j;
      m_strings[this->getI(i, j)] = istring.str();
    }
}

MbStringSetIj::MbStringSetIj(size_t sizeI, size_t sizeJ, const std::string& name, DataBinding binding)
  : MbStringSet(name, binding)
  , MbIjToI(sizeI)
  , m_numJ(sizeJ)
{
  s_numInstance++;

  m_strings.resize(this->m_numI*this->m_numJ);
  for (size_t i = 0; i < this->m_numI; ++i)
    for (size_t j = 0; j < this->m_numJ; ++j)
    {
      std::ostringstream istring;
      istring << "id:" << i << ", " << j;
      m_strings[this->getI(i, j)] = istring.str();
    }
}

std::string
MbStringSetIj::get(size_t i, size_t j) const
{
  return m_strings[this->getI(i, j)];
}

void
MbStringSetIj::getSize(size_t& sizeI, size_t& sizeJ) const
{
  sizeI = this->m_numI;
  sizeJ = this->m_numJ;
}

std::ostream&
MbStringSetIj::toStream(std::ostream& s) const
{
  s << "# stringset name" << std::endl;
  s << getName() << std::endl;
  s << "# stringset size" << std::endl;
  s << this->m_numI << "," << this->m_numJ << std::endl;
  for (size_t i = 0; i < this->m_numI; ++i)
    for (size_t j = 0; j < this->m_numJ; ++j)
      s << "value(" << i << "," << j << ")=" << get(i, j) << std::endl;

  return s;
}
