/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MBStringSetIj_H
#define  _MBStringSetIj_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/data/MiDataSetIj.h>

#include <data/MbDataSet.h>
#include <MbIjToI.h>
#include <MbMeshVizImpl.h>


#include <Inventor/STL/vector>
#include <Inventor/STL/iostream>
#include <Inventor/STL/sstream>
#include <Inventor/STL/algorithm>

/**
 * @DTEXT  Defines a set of string for Ij surfaces.
 * 
 * @ingroup MeshVizXLM_Implement_Data
 * 
 * @DESCRIPTION
 * 
 */
class MbStringSetIj : virtual public MiStringSetIj, public MbStringSet, private MbIjToI
{
public:

  /**
  * Constructor for an empty default dataset.
  * This dataset has a default name depending on the number of instances created.
  * Its binding is set to PER_NODE by default.
  */
  MbStringSetIj(size_t sizeI, size_t sizeJ);

  /**
  * Constructor for dataset with specific name and
  * specific data binding.
  */
  MbStringSetIj(size_t sizeI, size_t sizeJ, const std::string& name, DataBinding binding);

  /**
  * Returns the (i,j)-th value of this set.
  */
  virtual std::string get(size_t i, size_t j) const;

  /**
  * Returns the number of values in this set.
  */
  void getSize(size_t& sizeI, size_t& sizeJ) const;


protected:
  /**
  * Defines a specialized output on stream for MbStringSet
  */
  virtual std::ostream& toStream(std::ostream& s) const;

  static size_t s_numInstance;

  std::vector<std::string> m_strings;

  size_t m_numJ;

};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif

