/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MBStringSetIjk_H
#define  _MBStringSetIjk_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>

#include <data/MbDataSet.h>
#include <MbMeshVizImpl.h>


#include <Inventor/STL/vector>
#include <Inventor/STL/iostream>
#include <Inventor/STL/sstream>
#include <Inventor/STL/algorithm>

/**
 * @DTEXT  Defines a set of string for Ijk volumes.
 * 
 * @ingroup MeshVizXLM_Implement_Data
 * 
 * @DESCRIPTION
 * 
 */
template <typename MiMeshIjk::StorageLayout _Layout = MiMeshIjk::LAYOUT_KJI>
class MbStringSetIjk : virtual public MiStringSetIjk, public MbStringSet, private MbIjkToI<_Layout>
{
public:

  /**
  * Constructor for an empty default dataset.
  * This dataset has a default name depending on the number of instances created.
  * Its binding is set to PER_NODE by default.
  */
  MbStringSetIjk(size_t sizeI, size_t sizeJ, size_t sizeK);

  /**
  * Constructor for dataset with specific name and
  * specific data binding.
  */
  MbStringSetIjk(size_t sizeI, size_t sizeJ, size_t sizeK, const std::string& name, DataBinding binding);

  /**
  * Returns the (i,j,k)-th value of this set.
  */
  virtual std::string get(size_t i, size_t j, size_t k) const;

  virtual MiMeshIjk::StorageLayout getStorageLayout() const;

  /**
  * Returns the number of values in this set.
  */
  void getSize(size_t& sizeI, size_t& sizeJ, size_t& sizeK) const;


protected:
  /**
  * Defines a specialized output on stream for MbStringSet
  */
  virtual std::ostream& toStream(std::ostream& s) const;

  static size_t s_numInstance;

  std::vector<std::string> m_strings;

};

template <MiMeshIjk::StorageLayout _Layout>
size_t MbStringSetIjk<_Layout>::s_numInstance = 0;

template <MiMeshIjk::StorageLayout _Layout>
inline
MbStringSetIjk<_Layout>::MbStringSetIjk(size_t sizeI, size_t sizeJ, size_t sizeK)
: MbIjkToI<_Layout>(sizeI,sizeJ,sizeK)
{
  std::ostringstream defName;
  defName << "MbStringSet_#" << s_numInstance++;
  m_name = defName.str();

  m_strings.resize(this->m_numI*this->m_numJ*this->m_numK);
  for (size_t i=0; i< this->m_numI; ++i)
    for (size_t j=0; j< this->m_numJ; ++j)
      for (size_t k=0; k< this->m_numK; ++k)
      {
        std::ostringstream istring;
        istring << "id:" << i << ", " << j << ", " << k;
        m_strings[this->getI(i,j,k)] = istring.str();
      }
}

template <MiMeshIjk::StorageLayout _Layout>
inline
MbStringSetIjk<_Layout>::MbStringSetIjk(size_t sizeI, size_t sizeJ, size_t sizeK, const std::string& name, MiDataSet::DataBinding binding)
: MbStringSet(name, binding)
, MbIjkToI<_Layout>(sizeI,sizeJ,sizeK)
{
  s_numInstance++;

  m_strings.resize(this->m_numI*this->m_numJ*this->m_numK);
  for (size_t i=0; i< this->m_numI; ++i)
    for (size_t j=0; j< this->m_numJ; ++j)
      for (size_t k=0; k< this->m_numK; ++k)
      {
        std::ostringstream istring;
        istring << "id:" << i << ", " << j << ", " << k;
        m_strings[this->getI(i,j,k)] = istring.str();
      }
}

template <MiMeshIjk::StorageLayout _Layout>
std::string MbStringSetIjk<_Layout>::get(size_t i, size_t j, size_t k) const
{
  return m_strings[this->getI(i,j,k)];
}

template <MiMeshIjk::StorageLayout _Layout>
MiMeshIjk::StorageLayout MbStringSetIjk<_Layout>::getStorageLayout() const
{
  return _Layout;
}

template <MiMeshIjk::StorageLayout _Layout>
void MbStringSetIjk<_Layout>::getSize(size_t& sizeI, size_t& sizeJ, size_t& sizeK) const
{
  sizeI = this->m_numI;
  sizeJ = this->m_numJ;
  sizeK = this->m_numK;
}

template <MiMeshIjk::StorageLayout _Layout>
std::ostream& MbStringSetIjk<_Layout>::toStream(std::ostream& s) const
{
  s << "# stringset name" << std::endl;
  s << getName() << std::endl;
  s << "# stringset size" << std::endl;
  s << this->m_numI << "," << this->m_numJ << "," << this->m_numK << std::endl;
  for (size_t i=0; i< this->m_numI; ++i)
    for (size_t j=0; j< this->m_numJ; ++j)
      for (size_t k=0; k< this->m_numK; ++k)
        s << "value(" << i << "," << j << "," << k << ")=" << get(i,j,k) << std::endl;

  return s;
}

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif

