/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MBTYPEDDATASET__H
#define _MBTYPEDDATASET__H

#include <Inventor/STL/string>
#include <Inventor/STL/iostream>

#include <MeshVizXLM/mesh/data/MiTypedDataSet.h>

#include <MeshVizXLM/MxTimeStamp.h>

//-----------------------------------------------------------------------------
/**
* @DTEXT Generic data set implementation.
* 
* @ingroup MeshVizXLM_Implement_Data
* 
* @DESCRIPTION
*    A generic abstract template interface for a data set usable in any extract or geometry of a mesh.
* 
*/

template <typename _T>
class MbTypedDataSet: virtual public MiTypedDataSet<_T>
{
public:
  /**
  * Constructor for an empty default dataset. @BR
  * Initializes name to empty string, data binding to PER_NODE and
  * timestamp to 1.
  */
  MbTypedDataSet();

  /**
  * Constructor for dataset with specific name and
  * specific data binding. Initializes timestamp to 1.
  */
  MbTypedDataSet(const std::string& name, MiDataSet::DataBinding binding);

  /**
  * Returns the time stamp on this data set. When the content of the dataset
  * changes, the time stamp must also change. The time stamp allows MeshViz
  * to be aware of any change to this dataset.
  */
  virtual size_t getTimeStamp() const
  {
    return m_timeStamp;
  }

  /**
  * Returns the name of this dataset.
  */
  virtual std::string getName() const
  {
    return m_name;
  }

  /**
  * Define the name of this dataset (default is empty string).
  */
  virtual void setName(const std::string& name)
  {
    m_name = name;
  }

  /**
  * Returns the binding of this dataset.
  */
  virtual MiDataSet::DataBinding  getBinding() const
  {
    return m_binding;
  }

  /**
  * Define the data binding of this dataset (default is PER_NODE).
  */
  virtual void  setBinding(MiDataSet::DataBinding binding)
  {
    m_binding = binding;
  }

  /**
  * @internal
  * Simulate a modification to this dataset
  */
  void touch()
  {
    m_timeStamp = MxTimeStamp::getTimeStamp();
  }

protected:
  /**
  * Defines a specialized output on stream for MbDataSet
  */
  virtual std::ostream& toStream(std::ostream& s) const;

  MiDataSet::DataBinding      m_binding;
  std::string      m_name;
  size_t           m_timeStamp;

};

typedef MbTypedDataSet<std::string> MbStringSet;

//-----------------------------------------------------------------------------
template <typename _T>
inline
MbTypedDataSet<_T>::MbTypedDataSet()
: m_binding(MiDataSet::PER_NODE)
, m_name("")
, m_timeStamp(MxTimeStamp::getTimeStamp())
{
}

//-----------------------------------------------------------------------------
template <typename _T>
inline
MbTypedDataSet<_T>::MbTypedDataSet(const std::string& name, MiDataSet::DataBinding binding)
: m_binding(binding)
, m_name(name)
, m_timeStamp(MxTimeStamp::getTimeStamp())
{
}

//-----------------------------------------------------------------------------
template <typename _T>
inline std::ostream&
MbTypedDataSet<_T>::toStream(std::ostream& s) const
{
  s << "# dataset name" << std::endl;
  s <<  m_name << std::endl;
  s << "# databinding" << std::endl;
  if(m_binding ==  MiDataSet::PER_NODE)
    s <<  "PER_NODE" << std::endl;
  else
    s <<  "PER_CELL" << std::endl;
  return s;
}

#endif


