/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MBVEC3SETIJK_H
#define  _MBVEC3SETIJK_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
#include <MeshVizXLM/MbVec3.h>

#include <data/MbDataSet.h>
#include <MbIjkToI.h>
#include <MbMeshVizImpl.h>

#include <Inventor/STL/vector>
#include <Inventor/STL/iostream>
#include <Inventor/STL/sstream> 

/**
 * @DTEXT  Defines a set of 3D vectors.
 * 
 * @ingroup MeshVizXLM_Implement_Data
 * 
 * @DESCRIPTION

 * 
 */
template <typename _Vec3T=MbVec3d, MiMeshIjk::StorageLayout _Layout = MiMeshIjk::LAYOUT_KJI>
class MbVec3SetIjk : virtual public MiVec3dSetIjk, public MbVec3dSet, private MbIjkToI<_Layout>
{
public:
  //@{
  /**
  * Constructor for an empty default dataset.
  * This dataset has a default name depending on the number of instances created.
  * Its binding is set to PER_NODE by default.
  */
  MbVec3SetIjk();
  MbVec3SetIjk(size_t numI, size_t numJ, size_t numK);

  MbVec3SetIjk(size_t numI, size_t numJ, size_t numK, 
                 const std::string& name, DataBinding binding=PER_NODE);
  //@}
 
  /**
  * Returns the (i,j)-th value of this set.
  */
  MbVec3d get(size_t i, size_t j, size_t k) const;

  /**
  * Sets the (i,j)-th value of this set.
  */
  void set(size_t i, size_t j, size_t k, const _Vec3T& data);

  /**
  * Returns the number of values in this set.
  */
  virtual void getSize(size_t& sizeI, size_t& sizeJ, size_t& sizeK) const;
  /**
  * Sets the number of values in this set.
  */
  virtual void setSize(size_t sizeI, size_t sizeJ, size_t sizeK);

  MiMeshIjk::StorageLayout getStorageLayout() const { return _Layout; }

  /**
  * Returns the min of this set.
  */
  virtual MbVec3d getMin() const;
  /**
  * Returns the max of this set.
  */
  virtual MbVec3d getMax() const;

protected:
  /**
  * Defines a specialized output on stream for MbVec3Set
  */
  virtual std::ostream& toStream(std::ostream& s) const;

  std::vector<_Vec3T> m_coords;

  static size_t s_numInstance;
};

typedef MbVec3SetIjk<MbVec3d> MbVec3dSetIjk;

template <typename _Vec3T, MiMeshIjk::StorageLayout _Layout>
size_t MbVec3SetIjk<_Vec3T,_Layout>::s_numInstance = 0;

//-----------------------------------------------------------------------------
template <typename _Vec3T, MiMeshIjk::StorageLayout _Layout>
inline 
MbVec3SetIjk<_Vec3T,_Layout>::MbVec3SetIjk():
MbIjkToI<_Layout>(0,0,0)
{
  std::ostringstream defName; 
  defName << "MbVec3Set_#" << s_numInstance++;
  m_name = defName.str();
}

//-----------------------------------------------------------------------------
template <typename _Vec3T, MiMeshIjk::StorageLayout _Layout>
inline
MbVec3SetIjk<_Vec3T,_Layout>::MbVec3SetIjk(size_t numI, size_t numJ, size_t numK):
  MbIjkToI<_Layout>(numI,numJ,numK)
{
  std::ostringstream defName; 
  defName << "MbVec3Set_#" << s_numInstance++;
  m_name = defName.str();
  m_coords.resize(this->m_numI*this->m_numJ*this->m_numK);
}

//-----------------------------------------------------------------------------
template <typename _T, MiMeshIjk::StorageLayout _Layout>
inline 
MbVec3SetIjk<_T,_Layout>::MbVec3SetIjk(size_t numI, size_t numJ, size_t numK, 
                                   const std::string& name,
                                   DataBinding binding) 
: MbVec3dSet(name,binding), MbIjkToI<_Layout>(numI,numJ,numK)
{
  m_coords.resize(this->m_numI*this->m_numJ*this->m_numK);
  s_numInstance++;
}


template <typename _Vec3T, MiMeshIjk::StorageLayout _Layout>
MbVec3d
MbVec3SetIjk<_Vec3T,_Layout>::get(size_t i, size_t j, size_t k) const
{
  return (MbVec3d)m_coords[this->getI(i,j,k)]; 
}

template <typename _Vec3T, MiMeshIjk::StorageLayout _Layout>
void
MbVec3SetIjk<_Vec3T,_Layout>::set(size_t i, size_t j, size_t k, const _Vec3T& data)
{
  if (i<this->m_numI && j<this->m_numJ && k<this->m_numK) 
  {
    m_coords[this->getI(i,j,k)] = data;
    m_timeStamp = MxTimeStamp::getTimeStamp();
  }
}

//-----------------------------------------------------------------------------
template <typename _Vec3T, MiMeshIjk::StorageLayout _Layout>
void
MbVec3SetIjk<_Vec3T,_Layout>::getSize(size_t& i, size_t& j, size_t& k) const 
{
  i = this->m_numI;
  j = this->m_numJ;
  k = this->m_numK;
}

template <typename _Vec3T, MiMeshIjk::StorageLayout _Layout>
void
MbVec3SetIjk<_Vec3T,_Layout>::setSize(size_t i, size_t j, size_t k) 
{
  this->m_numI = i;
  this->m_numJ = j;
  this->m_numK = k;
  m_coords.resize(i*j*this->m_numK);
  m_timeStamp = MxTimeStamp::getTimeStamp();
}

//-----------------------------------------------------------------------------
template <typename _Vec3T, MiMeshIjk::StorageLayout _Layout>
inline MbVec3d
MbVec3SetIjk<_Vec3T,_Layout>::getMin() const
{
  size_t minvecId = 0;
  double minvecLn = m_coords[0].length();

  for (size_t i=1; i<m_coords.size(); ++i)
  {
    double vecLn = m_coords[i].length();
    if (vecLn < minvecLn)
    {
      minvecLn = vecLn;
      minvecId = i;
    }
  }
  return MbVec3d(m_coords[minvecId]);
}


//-----------------------------------------------------------------------------
template <typename _Vec3T, MiMeshIjk::StorageLayout _Layout>
inline MbVec3d
MbVec3SetIjk<_Vec3T,_Layout>::getMax() const
{
  size_t maxvecId = 0;
  double maxvecLn = m_coords[0].length();

  for (size_t i=1; i<m_coords.size(); ++i)
  {
    double vecLn = m_coords[i].length();
    if (vecLn > maxvecLn)
    {
      maxvecLn = vecLn;
      maxvecId = i;
    }
  }
  return MbVec3d(m_coords[maxvecId]);
}

//-----------------------------------------------------------------------------
template <typename _Vec3T, MiMeshIjk::StorageLayout _Layout>
inline std::ostream& 
MbVec3SetIjk<_Vec3T,_Layout>::toStream(std::ostream& s) const
{
  s << "# vec3set name" << std::endl; 
  s << getName() << std::endl; 
  s << "# vec3set size" << std::endl;
  s << this->m_numI << "," << this->m_numJ << "," << this->m_numK << std::endl;
  for (size_t i=0; i< this->m_numI; ++i) 
    for (size_t j=0; j< this->m_numJ; ++j)
      for (size_t k=0; k< this->m_numK; ++k)
        s << "value(" << i << "," << j << "," << k << ")=" << this->get(i,j,k) << std::endl;

  return s;
}

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif








