#include "PEBIScalarSet.h"
#include <mesh/volumes/PEBIMesh.h>


double
PEBIScalarSet::get(size_t i) const
{
  MbVec3d coord_at(m_mesh->getGeometry().getCoord(m_mesh->getTopology().getCell(i)->getNodeIndex(0)));
  return computeValue(coord_at); 
}

double
PEBIScalarSet::getMin() const
{
  return computeValue(MbVec3d(m_mesh->getCenter()));
}

double
PEBIScalarSet::getMax() const
{
  return computeValue(m_mesh->getGeometry().getMax());
}

PEBIScalarSet::DataBinding
PEBIScalarSet::getBinding() const
{
  return PER_CELL; 
}

std::string 
PEBIScalarSet::getName() const
{
	return "WELLDATASET";
}


double PEBIScalarSet::computeValue(MbVec3d coord_at) const
{
  double dist2 = sqrt(coord_at[0]*coord_at[0] + coord_at[1]*coord_at[1] );
  double dist3 = sqrt(coord_at[2]*coord_at[2] + dist2 * dist2);

  return dist3; 
}


