
#ifndef  _PEBISCALARSET_H
#define  _PEBISCALARSET_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <data/MbScalarSetI.h>

class PEBIMesh;

class PEBIScalarSet : public MbScalardSetI
{

public:
  PEBIScalarSet(PEBIMesh* mesh) {
	  m_mesh = mesh;
  }

  /**
  * Returns the i-th value of this set.
  */
  virtual double get(size_t i) const;

  /**
  * Returns the name of this data set.
  */
  virtual std::string getName() const;

  /**
  * Returns the data binding of this data set.
  */
  virtual DataBinding getBinding() const;

  double getMin() const;
  double getMax() const;

private:
  double computeValue(MbVec3d coord) const;
  PEBIMesh* m_mesh;
};


#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif








