#ifndef  _WheelDataset_h
#define  _WheelDataset_h

#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
template<typename _F>
class WheelDataset : public MiScalardSetI
{
public:
  WheelDataset(const MiVolumeMeshUnstructured& mesh);

  double get(size_t i) const 
  { 
    return m_values[i];
  }

  double getMin () const { return m_vmin; }
  double getMax () const { return m_vmax; }
  size_t  getTimeStamp () const  { return 1; }
  std::string getName () const  { return m_function.getName(); }
  DataBinding  getBinding () const { return PER_NODE; }

private:
  std::vector<double> m_values;
  double m_vmin,m_vmax;
  _F m_function;
};


//-----------------------------------------------------------------------------
template<typename _F>
WheelDataset<_F>::WheelDataset(const MiVolumeMeshUnstructured& mesh)
{
  size_t numNodes = mesh.getTopology().getEndNodeId();
  const MiGeometryI& geometry = mesh.getGeometry();
  m_values.reserve(numNodes);
  m_vmin = 1E30;
  m_vmax = -1E30;
  for (size_t i=mesh.getTopology().getBeginNodeId(); i!=mesh.getTopology().getEndNodeId(); ++i)
  {
    double v = m_function(geometry.getCoord(i));
    if (v < m_vmin) m_vmin = v;
    if (v > m_vmax) m_vmax = v;
    m_values.push_back(v);
  }
}

//-----------------------------------------------------------------------------
// List of functions used to define a several dataset
// Each function depends on the form f = f(x,y,z) 

class DistanceToXAxis
{
public:
  double operator()(const MbVec3d& coord) { return sqrt(coord[1]*coord[1] + coord[2]*coord[2]); }
  std::string getName() const { return "Distance to X axis"; }
};


class DistanceToYAxis
{
public:
  double operator()(const MbVec3d& coord) { return sqrt(coord[0]*coord[0] + coord[2]*coord[2]); }
  std::string getName() const { return "Distance to Y axis"; }
};

class DistanceToZAxis
{
public:
  double operator()(const MbVec3d& coord) { return sqrt(coord[0]*coord[0] + coord[1]*coord[1]); }
  std::string getName() const { return "Distance to Z axis"; }
};

class DistanceToOrigin
{
public:
  double operator()(const MbVec3d& coord) { return sqrt(coord[0]*coord[0] + coord[1]*coord[1] + coord[2]*coord[2]); }
  std::string getName() const { return "Distance to origin"; }
};

class Fx
{
public:
  double operator()(const MbVec3d& coord) { return coord[0]; }
  std::string getName() const { return "X"; }
};

class Fy
{
public:
  double operator()(const MbVec3d& coord) { return coord[1]; }
  std::string getName() const { return "Y"; }
};

class Fz
{
public:
  double operator()(const MbVec3d& coord) { return coord[2]; }
  std::string getName() const { return "Z"; }
};

#endif 


