/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MbGeometryHexahedronIjk_H
#define _MbGeometryHexahedronIjk_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#pragma warning(disable:4251)
#pragma warning(disable:4512)
#endif

#include <MeshVizXLM/mesh/geometry/MiGeometryHexahedronIjk.h>
#include <mesh/volumes/MbHexahedronMeshIjk.h>
#include <geometry/MbGeometry.h>

//-----------------------------------------------------------------------------
/**
* @DTEXT List of volume cells' coordinates.
* 
* @ingroup MeshVizXLM_Implement_Topology
* 
* @DESCRIPTION
*    A geometry for a non indexed hexahedron mesh Ijk. 
*    This geometry turns an indexed hexahedron mesh Ijk in a non-indexed geometry.
*    Hexahedrons are defines as follows:
* <PRE>
*                        J
*                        |
*                        |
*
*                       n3----------n2   facet 0 = 0123   
*                       /|          /|   facet 1 = 4765 
*                     /  |        /  |   facet 2 = 0374
*                   /    |      /    |   facet 3 = 1562    
*                 n7---------n6      |   facet 4 = 0451 
*                  |     |    |      |   facet 5 = 3267 
*                  |    n0----|-----n1    --- I               
*                  |    /     |     /                    
*                  |  /       |   /                      
*                  |/         | /                        
*                 n4---------n5                          
*             
*               /
*             /
*           K
* </PRE>
*/
template <MiMeshIjk::StorageLayout LAYOUT>
class MbGeometryHexahedronIjk : virtual public MiGeometryHexahedronIjk, public MbGeometry
{
public:
  /**
  * Constructor of an empty topology defined by its size in i,j,k
  */
  MbGeometryHexahedronIjk(const MbHexahedronMeshIjk<MbVec3d,double,MbVec3d,LAYOUT>& indexedMesh)
    : m_topology((const MbHexahedronTopologyExplicitIjk<LAYOUT>&)indexedMesh.getTopology()), m_geometry(indexedMesh.getGeometry()) {}

  /**
  * Returns 8 indices of a cell of this topology. The cell 
  * is identified by three id i,j,k.
  */
  void getCellCoords(size_t i, size_t j, size_t k, MbVec3d& v0, MbVec3d& v1, MbVec3d& v2, MbVec3d& v3,
                                                   MbVec3d& v4, MbVec3d& v5, MbVec3d& v6, MbVec3d& v7) const;

  virtual MiMeshIjk::StorageLayout getStorageLayout() const { return m_topology.getStorageLayout(); }

  size_t getTimeStamp() const { return m_timeStamp + m_topology.getTimeStamp() + m_geometry.getTimeStamp();}

protected:
  const MbHexahedronTopologyExplicitIjk<LAYOUT>& m_topology;
  const MbMeshGeometry<MbVec3d>& m_geometry;
};

//-----------------------------------------------------------------------------
template <MiMeshIjk::StorageLayout LAYOUT>
inline 
void MbGeometryHexahedronIjk<LAYOUT>::getCellCoords(size_t i, size_t j, size_t k, MbVec3d& v0, MbVec3d& v1, MbVec3d& v2, MbVec3d& v3,
                                                                                  MbVec3d& v4, MbVec3d& v5, MbVec3d& v6, MbVec3d& v7) const
{
  const size_t* id = m_topology.getCellNodeIndicesBuffer(i,j,k);
  v0 = m_geometry[id[0]];
  v1 = m_geometry[id[1]];
  v2 = m_geometry[id[2]];
  v3 = m_geometry[id[3]];
  v4 = m_geometry[id[4]];
  v5 = m_geometry[id[5]];
  v6 = m_geometry[id[6]];
  v7 = m_geometry[id[7]];
}

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif


