/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MBGEOMETRYIJ_H
#define _MBGEOMETRYIJ_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#pragma warning(disable:4251)
#endif

#include <MeshVizXLM/mesh/geometry/MiGeometry.h>
#include <MeshVizXLM/mesh/geometry/MiGeometryIj.h>

#include <geometry/MbGeometry.h>
#include <MbIjToI.h>
#include <MbError.h>

#include <Inventor/STL/vector>

/**
* @DTEXT Generic parallelepiped, rectangular or straight line geometry.
* 
* @ingroup MeshVizXLM_Implement_Geometry
* 
* @DESCRIPTION
*    The geometry is given by 2 points defining 2 extremities.
* 
*/
template <typename _Vec3T=MbVec3d>
class MbGeometryIj : public MiGeometryIj, public MbGeometry, private MbIjToI
{
public:
  /** Constructor */
  MbGeometryIj(size_t numNodesI, size_t numNodesJ) 
    : MbIjToI(numNodesI),m_numJ(numNodesJ),
    m_max(0), m_min(_Vec3T::numeric_limit_max())
  {
    m_coords.resize(m_numI*m_numJ);
  }

  /**
  * Returns the coordinate (i,j) of this geometry.
  */
  virtual MbVec3d getCoord(size_t i, size_t j) const 
  {
#ifndef MBMESH_DONT_USE_ASSERT
    if (m_numI <= i || m_numJ <= j)
      throw MbError("accessing coordinate out of range");
#endif
    return (MbVec3d) m_coords[getI(i,j)];
  }

  /**
  * Sets the coordinate (i,j).
  */
 virtual void setCoord(size_t i, size_t j, const _Vec3T& val ) 
  {
    if (i<m_numI && j<m_numJ) 
    {
      m_coords[getI(i,j)] = val;
      for(size_t d=0; d<3; ++d)
      {
        if(val[d] > m_max[d]) m_max[d] = val[d];
        if(val[d] < m_min[d]) m_min[d] = val[d];
      }
      m_timeStamp = MxTimeStamp::getTimeStamp();
    }
  }

  /**
  * Gets the size of the geometry.
  */
  void getSize(size_t &numNodesI, size_t &numNodesJ) const
  {
    numNodesI = m_numI;
    numNodesJ = m_numJ;
  }

   //@{
  /**
  * Gets the min and max of the geometry.
  */
  MbVec3d getMin() const { return (MbVec3d) m_min;}
  MbVec3d getMax() const { return (MbVec3d) m_max;}
  //@}

protected:

  std::vector<_Vec3T> m_coords;
  size_t m_numJ;
  _Vec3T m_max;
  _Vec3T m_min;

};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif


