/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MbGeometryIjk_H
#define _MbGeometryIjk_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#pragma warning(disable:4251)
#endif

#include <MeshVizXLM/mesh/geometry/MiGeometry.h>
#include <MeshVizXLM/mesh/geometry/MiGeometryIjk.h>

#include <geometry/MbGeometry.h>
#include <MbIjkToI.h>

#include <Inventor/STL/vector>

/**
* @DTEXT Generic parallelepiped, rectangular or straight line geometry.
* 
* @ingroup MeshVizXLM_Implement_Geometry
* 
* @DESCRIPTION
*    The geometry is given by 2 points defining 2 extremities.
* 
*/
template <typename _Vec3T=MbVec3d, MiMeshIjk::StorageLayout _Layout = MiMeshIjk::LAYOUT_KJI>
class MbGeometryIjk : public MiGeometryIjk, public MbGeometry, protected MbIjkToI<_Layout>
{
public:
  /** Constructor */
  MbGeometryIjk() : MbIjkToI<>(0,0),
    m_max(-_Vec3T::numeric_limit_max()), m_min(_Vec3T::numeric_limit_max())
  {
  }
  MbGeometryIjk(size_t numNodesI, size_t numNodesJ, size_t numNodesK) 
    : MbIjkToI<_Layout>(numNodesI,numNodesJ,numNodesK),
    m_min(_Vec3T::numeric_limit_max()), m_max(-_Vec3T::numeric_limit_max())
  {
    m_coords.resize(numNodesI*numNodesJ*numNodesK);
  }

  /**
  * Returns the coordinate (i,j,k) of this geometry.
  */
  virtual MbVec3d getCoord(size_t i, size_t j, size_t k) const 
  {
    return (MbVec3d) m_coords[this->getI(i,j,k)];
  }

  /**
  * Sets the coordinate at index (i,j,k).
  */
  virtual void setCoord(size_t i, size_t j, size_t k, const _Vec3T& val ) 
  {
    m_coords[this->getI(i,j,k)] = val;
    for(size_t d=0; d<3; ++d)
    {
      if(val[d] > m_max[d]) m_max[d] = val[d];
      if(val[d] < m_min[d]) m_min[d] = val[d];
    }
    m_timeStamp = MxTimeStamp::getTimeStamp();
  }

  /**
  * Gets the size of the geometry.
  */
  void setSize(size_t numNodesI, size_t numNodesJ, size_t numNodesK)
  {
    m_coords.resize(numNodesI*numNodesJ*numNodesK);
    m_timeStamp = MxTimeStamp::getTimeStamp();
  }

  /**
  * Gets the size of the geometry.
  */
  void getSize(size_t &numNodesI, size_t &numNodesJ, size_t &numNodesK)
  {
    numNodesI = this->m_numI;
    numNodesJ = this->m_numJ;
    numNodesK = this->m_numK;
  }

  virtual MiMeshIjk::StorageLayout getStorageLayout() const { return _Layout; }

  //@{
  /**
  * Gets the min and max of the geometry.
  */
  MbVec3d getMin() const { return (MbVec3d) m_min;}
  MbVec3d getMax() const { return (MbVec3d) m_max;}
  //@}

protected:

  std::vector<_Vec3T> m_coords;
  _Vec3T m_min;
  _Vec3T m_max;

};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif


